/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.highlighter;

import com.sonar.sslr.api.Token;
import java.util.LinkedList;
import org.sonar.api.source.Symbol;
import org.sonar.api.source.Symbolizable;
import org.sonar.javascript.highlighter.SourceFileOffsets;
import org.sonar.javascript.model.internal.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;

public class HighlightSymbolTableBuilder {
    private HighlightSymbolTableBuilder() {
    }

    public static Symbolizable.SymbolTable build(Symbolizable symbolizable, SymbolModel symbolModel, SourceFileOffsets sourceFileOffsets) {
        Symbolizable.SymbolTableBuilder builder = symbolizable.newSymbolTableBuilder();
        for (org.sonar.plugins.javascript.api.symbols.Symbol symbol : symbolModel.getSymbols()) {
            if (symbol.usages().isEmpty()) continue;
            LinkedList<Usage> usagesList = new LinkedList<Usage>(symbol.usages());
            InternalSyntaxToken token = (InternalSyntaxToken)((Usage)usagesList.get(0)).identifierTree().identifierToken();
            Symbol reference = HighlightSymbolTableBuilder.getHighlightedSymbol(sourceFileOffsets, builder, token);
            for (int i = 1; i < usagesList.size(); ++i) {
                builder.newReference(reference, sourceFileOffsets.startOffset(HighlightSymbolTableBuilder.getToken(((Usage)usagesList.get(i)).identifierTree())));
            }
        }
        return builder.build();
    }

    private static Symbol getHighlightedSymbol(SourceFileOffsets sourceFileOffsets, Symbolizable.SymbolTableBuilder builder, InternalSyntaxToken token) {
        int startOffset = sourceFileOffsets.startOffset(token.getToken());
        int endOffset = sourceFileOffsets.endOffset(token.getToken());
        return builder.newSymbol(startOffset, endOffset);
    }

    private static Token getToken(IdentifierTree identifierTree) {
        return ((InternalSyntaxToken)identifierTree.identifierToken()).getToken();
    }
}

