/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.config.Settings;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.Issue;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.RangeDistributionBuilder;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.source.Highlightable;
import org.sonar.javascript.EcmaScriptConfiguration;
import org.sonar.javascript.JavaScriptAstScanner;
import org.sonar.javascript.api.EcmaScriptMetric;
import org.sonar.javascript.ast.visitors.VisitorsBridge;
import org.sonar.javascript.checks.CheckList;
import org.sonar.javascript.highlighter.JavaScriptHighlighter;
import org.sonar.javascript.metrics.FileLinesVisitor;
import org.sonar.plugins.javascript.JavaScriptChecks;
import org.sonar.plugins.javascript.api.CustomJavaScriptRulesDefinition;
import org.sonar.plugins.javascript.api.JavaScriptFileScanner;
import org.sonar.squidbridge.AstScanner;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.CodeVisitor;
import org.sonar.squidbridge.api.Query;
import org.sonar.squidbridge.api.SourceClass;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.api.SourceFunction;
import org.sonar.squidbridge.indexer.QueryByParent;
import org.sonar.squidbridge.indexer.QueryByType;
import org.sonar.squidbridge.measures.MetricDef;
import org.sonar.sslr.parser.LexerlessGrammar;

public class JavaScriptSquidSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(JavaScriptSquidSensor.class);
    private static final Number[] FUNCTIONS_DISTRIB_BOTTOM_LIMITS = new Number[]{1, 2, 4, 6, 8, 10, 12, 20, 30};
    private static final Number[] FILES_DISTRIB_BOTTOM_LIMITS = new Number[]{0, 5, 10, 20, 30, 60, 90};
    private final JavaScriptChecks checks;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final ResourcePerspectives resourcePerspectives;
    private final FileSystem fileSystem;
    private final NoSonarFilter noSonarFilter;
    private final FilePredicate mainFilePredicate;
    private final PathResolver pathResolver;
    private final Settings settings;
    private SensorContext context;
    private AstScanner<LexerlessGrammar> scanner;

    @DependedUpon
    public Collection<Metric> generatesNCLOCMetric() {
        return ImmutableList.of((Object)CoreMetrics.NCLOC, (Object)CoreMetrics.NCLOC_DATA);
    }

    public JavaScriptSquidSensor(CheckFactory checkFactory, FileLinesContextFactory fileLinesContextFactory, ResourcePerspectives resourcePerspectives, FileSystem fileSystem, NoSonarFilter noSonarFilter, PathResolver pathResolver, Settings settings) {
        this(checkFactory, fileLinesContextFactory, resourcePerspectives, fileSystem, noSonarFilter, pathResolver, settings, null);
    }

    public JavaScriptSquidSensor(CheckFactory checkFactory, FileLinesContextFactory fileLinesContextFactory, ResourcePerspectives resourcePerspectives, FileSystem fileSystem, NoSonarFilter noSonarFilter, PathResolver pathResolver, Settings settings, @Nullable CustomJavaScriptRulesDefinition[] customRulesDefinition) {
        this.checks = JavaScriptChecks.createJavaScriptCheck(checkFactory).addChecks("javascript", CheckList.getChecks()).addCustomChecks(customRulesDefinition);
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.resourcePerspectives = resourcePerspectives;
        this.fileSystem = fileSystem;
        this.noSonarFilter = noSonarFilter;
        this.pathResolver = pathResolver;
        this.mainFilePredicate = fileSystem.predicates().and(fileSystem.predicates().hasType(InputFile.Type.MAIN), fileSystem.predicates().hasLanguage("js"));
        this.settings = settings;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.fileSystem.hasFiles(this.mainFilePredicate);
    }

    public void analyse(Project project, SensorContext context) {
        this.context = context;
        ArrayList astNodeVisitors = Lists.newArrayList();
        ArrayList treeVisitors = Lists.newArrayList();
        for (CodeVisitor visitor : this.checks.all()) {
            if (visitor instanceof JavaScriptFileScanner) {
                treeVisitors.add((JavaScriptFileScanner)visitor);
                continue;
            }
            astNodeVisitors.add(visitor);
        }
        astNodeVisitors.add(new VisitorsBridge((List)treeVisitors, this.resourcePerspectives, this.fileSystem, this.settings));
        astNodeVisitors.add(new FileLinesVisitor(this.fileLinesContextFactory, this.fileSystem, this.pathResolver));
        this.scanner = JavaScriptAstScanner.create((EcmaScriptConfiguration)this.createConfiguration(), (SquidAstVisitor[])astNodeVisitors.toArray(new SquidAstVisitor[astNodeVisitors.size()]));
        this.scanner.scanFiles((Collection)Lists.newArrayList((Iterable)this.fileSystem.files(this.mainFilePredicate)));
        Collection squidSourceFiles = this.scanner.getIndex().search(new Query[]{new QueryByType(SourceFile.class)});
        this.save(squidSourceFiles);
        this.highlight();
    }

    private void highlight() {
        JavaScriptHighlighter highlighter = new JavaScriptHighlighter(this.createConfiguration());
        for (InputFile inputFile : this.fileSystem.inputFiles(this.mainFilePredicate)) {
            Highlightable perspective = (Highlightable)this.resourcePerspectives.as(Highlightable.class, (InputPath)inputFile);
            if (perspective != null) {
                highlighter.highlight(perspective, inputFile.file());
                continue;
            }
            LOG.warn("Could not get " + Highlightable.class.getCanonicalName() + " for " + inputFile.file());
        }
    }

    private EcmaScriptConfiguration createConfiguration() {
        return new EcmaScriptConfiguration(this.fileSystem.encoding());
    }

    private void save(Collection<SourceCode> squidSourceFiles) {
        for (SourceCode squidSourceFile : squidSourceFiles) {
            SourceFile squidFile = (SourceFile)squidSourceFile;
            org.sonar.api.resources.File sonarFile = (org.sonar.api.resources.File)this.context.getResource((Resource)org.sonar.api.resources.File.create((String)this.pathResolver.relativePath(this.fileSystem.baseDir(), new File(squidFile.getKey()))));
            if (sonarFile != null) {
                this.noSonarFilter.addResource((Resource)sonarFile, squidFile.getNoSonarTagLines());
                this.saveClassComplexity(sonarFile, squidFile);
                this.saveFilesComplexityDistribution(sonarFile, squidFile);
                this.saveFunctionsComplexityAndDistribution(sonarFile, squidFile);
                this.saveMeasures(sonarFile, squidFile);
                this.saveIssues(sonarFile, squidFile);
                continue;
            }
            LOG.warn("Cannot save analysis information for file {}. Unable to retrieve the associated sonar resource.", (Object)squidFile.getKey());
        }
    }

    private void saveMeasures(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.LINES, Double.valueOf(squidFile.getDouble((MetricDef)EcmaScriptMetric.LINES)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.NCLOC, Double.valueOf(squidFile.getDouble((MetricDef)EcmaScriptMetric.LINES_OF_CODE)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.CLASSES, Double.valueOf(squidFile.getDouble((MetricDef)EcmaScriptMetric.CLASSES)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.FUNCTIONS, Double.valueOf(squidFile.getDouble((MetricDef)EcmaScriptMetric.FUNCTIONS)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.ACCESSORS, Double.valueOf(squidFile.getDouble((MetricDef)EcmaScriptMetric.ACCESSORS)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.STATEMENTS, Double.valueOf(squidFile.getDouble((MetricDef)EcmaScriptMetric.STATEMENTS)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.COMPLEXITY, Double.valueOf(squidFile.getDouble((MetricDef)EcmaScriptMetric.COMPLEXITY)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.COMMENT_LINES, Double.valueOf(squidFile.getDouble((MetricDef)EcmaScriptMetric.COMMENT_LINES)));
    }

    private void saveClassComplexity(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        double complexityInClasses = 0.0;
        Set children = squidFile.getChildren();
        if (children != null) {
            for (SourceCode sourceCode : squidFile.getChildren()) {
                if (!sourceCode.isType(SourceClass.class)) continue;
                complexityInClasses += sourceCode.getDouble((MetricDef)EcmaScriptMetric.COMPLEXITY);
            }
        }
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.COMPLEXITY_IN_CLASSES, Double.valueOf(complexityInClasses));
    }

    private void saveFunctionsComplexityAndDistribution(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        Collection squidFunctionsInFile = this.scanner.getIndex().search(new Query[]{new QueryByParent((SourceCode)squidFile), new QueryByType(SourceFunction.class)});
        RangeDistributionBuilder complexityDistribution = new RangeDistributionBuilder(CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, FUNCTIONS_DISTRIB_BOTTOM_LIMITS);
        double complexityInFunction = 0.0;
        for (SourceCode squidFunction : squidFunctionsInFile) {
            double functionComplexity = squidFunction.getDouble((MetricDef)EcmaScriptMetric.COMPLEXITY);
            complexityDistribution.add((Number)functionComplexity);
            complexityInFunction += functionComplexity;
        }
        this.context.saveMeasure((Resource)sonarFile, complexityDistribution.build().setPersistenceMode(PersistenceMode.MEMORY));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.COMPLEXITY_IN_FUNCTIONS, Double.valueOf(complexityInFunction));
    }

    private void saveFilesComplexityDistribution(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        RangeDistributionBuilder complexityDistribution = new RangeDistributionBuilder(CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION, FILES_DISTRIB_BOTTOM_LIMITS);
        complexityDistribution.add((Number)squidFile.getDouble((MetricDef)EcmaScriptMetric.COMPLEXITY));
        this.context.saveMeasure((Resource)sonarFile, complexityDistribution.build().setPersistenceMode(PersistenceMode.MEMORY));
    }

    private void saveIssues(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        Set messages = squidFile.getCheckMessages();
        if (messages != null) {
            for (CheckMessage message : messages) {
                RuleKey ruleKey = this.checks.ruleKeyFor((CodeVisitor)message.getCheck());
                Issuable issuable = (Issuable)this.resourcePerspectives.as(Issuable.class, (Resource)sonarFile);
                if (issuable == null || ruleKey == null) continue;
                Issue issue = issuable.newIssueBuilder().ruleKey(ruleKey).line(message.getLine()).message(message.getText(Locale.ENGLISH)).build();
                issuable.addIssue(issue);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

