/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlMonitor;
import org.sqlproc.engine.SqlMonitorFactory;
import org.sqlproc.engine.impl.SqlMappingRule;
import org.sqlproc.engine.impl.SqlMetaStatement;

public class SqlEngineLoader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String COMMON_PREFIX = "LIST_";
    private static final String SQL_SUFFIX = "_SQL";
    private static final String FIELDS_SUFFIX = "_FIELDS";
    private static final int lCOMMON_PREFIX = "LIST_".length();
    private static final int lSQL_SUFFIX = "_SQL".length();
    private static final int lFIELDS_SUFFIX = "_FIELDS".length();
    private static final String SET_PREFIX = "SET_";
    private static final int lSET_PREFIX = "SET_".length();
    private static final String FIELDS_REFERENCE = "#";
    private static final int lFIELDS_REFERENCE = "#".length();
    private Map<String, SqlEngine> engines = new HashMap<String, SqlEngine>();
    private Map<String, String> sqls = new HashMap<String, String>();
    private Map<String, String> fields = new HashMap<String, String>();
    private Map<String, Object> features = new HashMap<String, Object>();

    public SqlEngineLoader(Properties props) throws SqlEngineException {
        this(props, null, null);
    }

    public SqlEngineLoader(Properties props, SqlMonitorFactory monitorFactory) throws SqlEngineException {
        this(props, monitorFactory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlEngineLoader(Properties props, SqlMonitorFactory monitorFactory, String ... selectQueries) throws SqlEngineException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> SqlEngineLoader, props=" + props + ", monitorFactory=" + monitorFactory + ", selectQueries=" + selectQueries);
        }
        try {
            HashSet<String> setSelectQueries = selectQueries != null ? new HashSet<String>(Arrays.asList(selectQueries)) : null;
            StringBuilder errors = new StringBuilder();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                String name = null;
                if (key.startsWith(COMMON_PREFIX) && key.endsWith(SQL_SUFFIX)) {
                    name = key.substring(lCOMMON_PREFIX, key.length() - lSQL_SUFFIX);
                    if (setSelectQueries != null && !setSelectQueries.contains(name)) continue;
                    if (this.sqls.containsKey(name)) {
                        errors.append("Dumplikatni nazev SQL: ").append(key).append("\n");
                        continue;
                    }
                    this.sqls.put(name, value);
                    continue;
                }
                if (key.startsWith(COMMON_PREFIX) && key.endsWith(FIELDS_SUFFIX)) {
                    name = key.substring(lCOMMON_PREFIX, key.length() - lFIELDS_SUFFIX);
                    if (setSelectQueries != null && !setSelectQueries.contains(name)) continue;
                    if (this.fields.containsKey(name)) {
                        errors.append("Dumplikatni nazev FIELDS: ").append(key).append("\n");
                        continue;
                    }
                    this.fields.put(name, value);
                    continue;
                }
                if (key.startsWith(SET_PREFIX)) {
                    name = key.substring(lSET_PREFIX);
                    if ("true".equalsIgnoreCase(value)) {
                        this.features.put(name, Boolean.TRUE);
                        continue;
                    }
                    if ("false".equalsIgnoreCase(value)) {
                        this.features.put(name, Boolean.FALSE);
                        continue;
                    }
                    this.features.put(name, value);
                    continue;
                }
                errors.append("Chybny nazev SQL/FIELDS/SET: ").append(key).append("\n");
            }
            for (String name : this.sqls.keySet()) {
                if (this.fields.containsKey(name)) continue;
                errors.append("K nazvu SQL neexistuje FIELDS: ").append(name).append("\n");
            }
            for (String name : this.fields.keySet()) {
                if (this.sqls.containsKey(name)) continue;
                errors.append("K nazvu FIELDS neexistuje SQLS: ").append(name).append("\n");
            }
            if (errors.length() > 0) {
                throw new SqlEngineException(errors.toString());
            }
            for (String name : this.sqls.keySet()) {
                SqlMonitor monitor;
                SqlMetaStatement stmt = null;
                try {
                    stmt = SqlMetaStatement.getInstance(this.sqls.get(name));
                }
                catch (SqlEngineException see) {
                    errors.append(see.getMessage());
                }
                SqlMappingRule mapping = null;
                try {
                    String sMapping = this.fields.get(name).trim();
                    if (sMapping.startsWith(FIELDS_REFERENCE)) {
                        String sRealMapping = props.getProperty(sMapping.substring(lFIELDS_REFERENCE).trim());
                        if (sRealMapping == null) {
                            errors.append("K referenci neexistuje FIELDS: ").append(name).append("->").append(sMapping).append("\n");
                        } else {
                            mapping = SqlMappingRule.getInstance(sRealMapping);
                        }
                    } else {
                        mapping = SqlMappingRule.getInstance(sMapping);
                    }
                }
                catch (SqlEngineException see) {
                    errors.append(see.getMessage());
                }
                SqlMonitor sqlMonitor = monitor = monitorFactory != null ? monitorFactory.getSqlMonitor(name, this.features) : null;
                if (stmt == null || mapping == null) continue;
                this.engines.put(name, new SqlEngine(name, stmt, mapping, monitor, this.features));
            }
            if (errors.length() > 0) {
                throw new SqlEngineException(errors.toString());
            }
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< SqlEngineLoader, engines=" + this.engines + ", sqls=" + this.sqls + ", fields=" + this.fields + ", features=" + this.features);
            }
        }
    }

    public Collection<String> getNames() {
        return this.engines.keySet();
    }

    public String getMetaSql(String name) {
        return this.sqls.get(name);
    }

    public String getMappingRule(String name) {
        return this.fields.get(name);
    }

    public SqlEngine getSqlEngine(String name) {
        return this.engines.get(name);
    }

    public SqlMonitor getSqlMonitor(String name) {
        return this.getSqlEngine(name).getMonitor();
    }
}

