/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.SQLQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.SqlMappingAttribute;
import org.sqlproc.engine.impl.SqlMappingIdentity;
import org.sqlproc.engine.impl.SqlMappingItem;
import org.sqlproc.engine.impl.SqlMappingRule;

public class SqlMappingResult {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, SqlMappingItem> mappings = new LinkedHashMap<String, SqlMappingItem>();
    Map<String, SqlMappingIdentity> identities = new LinkedHashMap<String, SqlMappingIdentity>();
    List<Integer> identitiesIndexes = new ArrayList<Integer>();
    Integer mainIdentityIndex;

    SqlMappingResult(SqlMappingRule mapping, Map<String, SqlMappingItem> outputMappings) {
        this.merge(mapping, outputMappings);
    }

    public Integer getMainIdentityIndex() {
        return this.mainIdentityIndex;
    }

    void addMapping(SqlMappingItem item) {
        this.mappings.put(item.getDbName(), item);
        if (item.getAttributes().isEmpty()) {
            String name = item.getName();
            if (!this.identities.containsKey(name)) {
                SqlMappingIdentity ident = new SqlMappingIdentity(item);
                this.identities.put(name, ident);
            }
        } else {
            for (SqlMappingAttribute attr : item.getAttributes()) {
                if (this.identities.containsKey(attr.getFullName())) continue;
                SqlMappingIdentity ident = new SqlMappingIdentity(item, attr);
                this.identities.put(attr.getFullName(), ident);
            }
        }
    }

    void calculateIdentities() {
        int identityIndex = 0;
        for (SqlMappingItem item : this.mappings.values()) {
            if (item.isIdentity()) {
                this.identitiesIndexes.add(identityIndex);
                if (item.getName().equals(item.getFullName())) {
                    SqlMappingIdentity ident = this.identities.get(item.getName());
                    ident.addIdentityIndex(identityIndex, true);
                    ident.idenityDistance = 0;
                    this.mainIdentityIndex = identityIndex;
                } else {
                    int size = item.getAttributes().size();
                    int distance = 0;
                    int i = size - 1;
                    while (i >= 0) {
                        SqlMappingAttribute attr = item.getAttributes().get(i);
                        SqlMappingIdentity ident = this.identities.get(attr.getFullName());
                        if (ident.identityIndexes == null || ident.idenityDistance >= distance) {
                            if (ident.identityIndexes != null && ident.idenityDistance == distance) {
                                ident.addIdentityIndex(identityIndex, false);
                            } else {
                                ident.addIdentityIndex(identityIndex, true);
                                ident.idenityDistance = distance;
                            }
                        }
                        --i;
                        ++distance;
                    }
                }
            }
            ++identityIndex;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("===  calculateIdentities, identities=" + this.identities);
        }
        if (this.identitiesIndexes.isEmpty()) {
            return;
        }
        for (SqlMappingItem item : this.mappings.values()) {
            if (item.isIdentity()) continue;
            if (item.getAttributes().isEmpty()) {
                SqlMappingIdentity ident = this.identities.get(item.getName());
                ident.addIdentityIndex(this.mainIdentityIndex, true);
                continue;
            }
            int size = item.getAttributes().size();
            block3: for (int i = size - 1; i >= 0; --i) {
                SqlMappingAttribute attr = item.getAttributes().get(i);
                SqlMappingIdentity ident = this.identities.get(attr.getFullName());
                if (ident.identityIndexes != null || i <= 0) continue;
                for (int j = i - 1; j >= 0; --j) {
                    SqlMappingAttribute attr2 = item.getAttributes().get(j);
                    SqlMappingIdentity ident2 = this.identities.get(attr2.getFullName());
                    if (ident2.identityIndexes == null) continue;
                    ident.identityIndexes = ident2.identityIndexes;
                    continue block3;
                }
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("<<<  calculateIdentities, identities=" + this.identities + ", identitiesIndexes=" + this.identitiesIndexes + ", mainIdentityIndex=" + this.mainIdentityIndex);
        }
    }

    public void setQueryResultMapping(Class<?> resultClass, Map<String, Class<?>> moreResultClasses, SQLQuery query) throws SqlRuntimeException {
        for (SqlMappingItem item : this.mappings.values()) {
            item.setQueryResultMapping(resultClass, moreResultClasses, query);
        }
    }

    public void setQueryResultData(Object resultInstance, Object[] resultValues, Map<String, Object> instances, boolean[] changedIdentities, Map<String, Class<?>> moreResultClasses) throws SqlRuntimeException {
        int i = 0;
        HashSet<String> allocatedContainers = new HashSet<String>();
        for (SqlMappingItem item : this.mappings.values()) {
            item.setQueryResultData(resultInstance, resultValues[i], instances, allocatedContainers, changedIdentities, this.identities, moreResultClasses);
            ++i;
        }
    }

    private void merge(SqlMappingRule mapping, Map<String, SqlMappingItem> outputMappings) {
        if (outputMappings == null || outputMappings.isEmpty()) {
            for (SqlMappingItem mappingItem : mapping.getMappings().values()) {
                this.addMapping(mappingItem);
            }
        } else {
            for (SqlMappingItem mappingItem : outputMappings.values()) {
                if (mapping != null && mapping.getMappings().containsKey(mappingItem.getDbName())) {
                    this.addMapping(mapping.getMappings().get(mappingItem.getDbName()).merge(mappingItem));
                    continue;
                }
                this.addMapping(mappingItem);
            }
        }
        this.calculateIdentities();
    }
}

