/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl.type;

import java.lang.reflect.Method;
import java.util.Collection;
import org.hibernate.Query;
import org.hibernate.type.Type;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.type.SqlMetaType;

public abstract class SqlGenericType
extends SqlMetaType {
    public abstract Type getHibernateType();

    public abstract Class<?>[] getClassTypes();

    public abstract String[] getMetaTypes();

    @Override
    public void setResult(Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        Method m;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setResult " + this.getMetaTypes()[0] + ": resultInstance=" + resultInstance + ", attributeName=" + attributeName + ", resultValue=" + resultValue);
        }
        if ((m = BeanUtils.getSetter(resultInstance, attributeName, this.getClassTypes())) != null) {
            BeanUtils.simpleInvokeMethod(m, resultInstance, resultValue);
        } else if (ingoreError) {
            this.logger.error("There's no getter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
        } else {
            throw new SqlRuntimeException("There's no setter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
        }
    }

    @Override
    public void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, boolean ingoreError) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setParameter " + this.getMetaTypes()[0] + ": paramName=" + paramName + ", inputValue=" + inputValue + ", inputType=" + inputType);
        }
        if (inputValue == null) {
            query.setParameter(paramName, inputValue, this.getHibernateType());
        } else if (inputValue instanceof Collection) {
            query.setParameterList(paramName, ((Collection)inputValue).toArray(), this.getHibernateType());
        } else {
            query.setParameter(paramName, inputValue, this.getHibernateType());
        }
    }
}

