/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl.type;

import java.lang.reflect.Method;
import java.util.Date;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.type.Type;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.type.SqlGenericType;

public class SqlTimeType
extends SqlGenericType {
    @Override
    public Type getHibernateType() {
        return Hibernate.TIME;
    }

    @Override
    public Class<?>[] getClassTypes() {
        return new Class[0];
    }

    @Override
    public String[] getMetaTypes() {
        return new String[]{"TIME"};
    }

    @Override
    public void setResult(Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        Method m;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setResult " + this.getMetaTypes()[0] + ": resultInstance=" + resultInstance + ", attributeName=" + attributeName + ", resultValue=" + resultValue);
        }
        if ((m = BeanUtils.getSetter(resultInstance, attributeName, Date.class)) != null) {
            BeanUtils.simpleInvokeMethod(m, resultInstance, resultValue);
        } else {
            m = BeanUtils.getSetter(resultInstance, attributeName, LocalTime.class);
            if (m != null) {
                LocalTime dt = new LocalTime(resultValue);
                BeanUtils.simpleInvokeMethod(m, resultInstance, dt);
            } else if (ingoreError) {
                this.logger.error("There's no getter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
            } else {
                throw new SqlRuntimeException("There's no setter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
            }
        }
    }

    @Override
    public void setParameter(Query query, String paramName, Object inputValue, Class<?> inputType, boolean ingoreError) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setParameter " + this.getMetaTypes()[0] + ": paramName=" + paramName + ", inputValue=" + inputValue + ", inputType=" + inputType);
        }
        if (inputValue == null) {
            query.setParameter(paramName, inputValue, (Type)Hibernate.TIME);
        } else {
            DateTime dt = new DateTime(inputValue).withMillisOfSecond(0);
            query.setTime(paramName, dt.toDate());
        }
    }
}

