/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jdbc.type;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.sqlproc.engine.jdbc.type.JdbcSqlType;
import org.sqlproc.engine.type.SqlBigDecimalType;

public class JdbcBigDecimalType
extends SqlBigDecimalType
implements JdbcSqlType {
    @Override
    public Object getProviderSqlType() {
        return this;
    }

    @Override
    public Object getProviderSqlNullType() {
        return 2;
    }

    @Override
    public Object get(ResultSet rs, String columnLabel) throws SQLException {
        if (Character.isDigit(columnLabel.charAt(0))) {
            return rs.getBigDecimal(Integer.parseInt(columnLabel));
        }
        return rs.getBigDecimal(columnLabel);
    }

    @Override
    public void set(PreparedStatement st, int index, Object value) throws SQLException {
        st.setBigDecimal(index, (BigDecimal)value);
    }

    @Override
    public Object get(CallableStatement cs, int index) throws SQLException {
        BigDecimal result = cs.getBigDecimal(index);
        if (cs.wasNull()) {
            return null;
        }
        return result;
    }
}

