/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.external.apache.http.impl.io;

import org.testobject.external.apache.http.HttpResponse;
import org.testobject.external.apache.http.HttpResponseFactory;
import org.testobject.external.apache.http.annotation.Immutable;
import org.testobject.external.apache.http.config.MessageConstraints;
import org.testobject.external.apache.http.impl.DefaultHttpResponseFactory;
import org.testobject.external.apache.http.impl.io.DefaultHttpResponseParser;
import org.testobject.external.apache.http.io.HttpMessageParser;
import org.testobject.external.apache.http.io.HttpMessageParserFactory;
import org.testobject.external.apache.http.io.SessionInputBuffer;
import org.testobject.external.apache.http.message.BasicLineParser;
import org.testobject.external.apache.http.message.LineParser;

@Immutable
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

