/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api.outputBuffer;

import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.utplsql.api.outputBuffer.OutputBuffer;
import org.utplsql.api.reporter.Reporter;

abstract class AbstractOutputBuffer
implements OutputBuffer {
    private final Reporter reporter;
    private int fetchSize = 100;

    AbstractOutputBuffer(Reporter reporter) {
        assert (reporter.isInit()) : "Reporter is not initialized! You can only create OutputBuffers for initialized Reporters";
        this.reporter = reporter;
    }

    @Override
    public Reporter getReporter() {
        return this.reporter;
    }

    @Override
    public OutputBuffer setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    @Override
    public void printAvailable(Connection conn, PrintStream ps) throws SQLException {
        ArrayList<PrintStream> printStreams = new ArrayList<PrintStream>(1);
        printStreams.add(ps);
        this.printAvailable(conn, printStreams);
    }

    @Override
    public void printAvailable(Connection conn, List<PrintStream> printStreams) throws SQLException {
        this.fetchAvailable(conn, s -> {
            for (PrintStream ps : printStreams) {
                ps.println((String)s);
            }
        });
    }

    protected abstract CallableStatement getLinesCursorStatement(Connection var1) throws SQLException;

    @Override
    public void fetchAvailable(Connection conn, Consumer<String> onLineFetched) throws SQLException {
        try (CallableStatement cstmt = this.getLinesCursorStatement(conn);){
            cstmt.execute();
            cstmt.setFetchSize(this.fetchSize);
            try (ResultSet resultSet = (ResultSet)cstmt.getObject(1);){
                while (resultSet.next()) {
                    onLineFetched.accept(resultSet.getString("text"));
                }
            }
        }
    }

    @Override
    public List<String> fetchAll(Connection conn) throws SQLException {
        try (CallableStatement cstmt = this.getLinesCursorStatement(conn);){
            ArrayList<String> arrayList;
            block13: {
                cstmt.execute();
                cstmt.setFetchSize(this.fetchSize);
                ResultSet resultSet = (ResultSet)cstmt.getObject(1);
                try {
                    ArrayList<String> outputLines = new ArrayList<String>();
                    while (resultSet.next()) {
                        outputLines.add(resultSet.getString("text"));
                    }
                    arrayList = outputLines;
                    if (resultSet == null) break block13;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return arrayList;
        }
    }
}

