/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.framework.knowledge;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.framework.traits.ImplicitErrorsTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;

public final class ImplicitErrorIndex
implements KnowledgeIndex {
    private final Map<ShapeId, Set<ShapeId>> serviceImplicitErrorMap = new HashMap<ShapeId, Set<ShapeId>>();
    private final Set<ShapeId> implicitErrors = new HashSet<ShapeId>();

    private ImplicitErrorIndex(Model model) {
        for (ServiceShape service : model.getServiceShapes()) {
            for (Map.Entry traitEntry : service.getAllTraits().entrySet()) {
                Shape traitShape;
                Optional traitShapeOptional = model.getShape((ShapeId)traitEntry.getKey());
                if (traitShapeOptional.isEmpty() || !(traitShape = (Shape)traitShapeOptional.get()).hasTrait(ImplicitErrorsTrait.class)) continue;
                ImplicitErrorsTrait implicitErrorsTrait = (ImplicitErrorsTrait)traitShape.expectTrait(ImplicitErrorsTrait.class);
                Set implicitErrorList = this.serviceImplicitErrorMap.computeIfAbsent(service.toShapeId(), k -> new HashSet());
                implicitErrorList.addAll(implicitErrorsTrait.getValues());
                this.implicitErrors.addAll(implicitErrorsTrait.getValues());
            }
        }
    }

    public static ImplicitErrorIndex of(Model model) {
        return (ImplicitErrorIndex)model.getKnowledge(ImplicitErrorIndex.class, ImplicitErrorIndex::new);
    }

    public Set<ShapeId> getImplicitErrorsForService(ToShapeId toShapeId) {
        return this.serviceImplicitErrorMap.computeIfAbsent(toShapeId.toShapeId(), k -> new HashSet());
    }

    public boolean isImplicitError(ShapeId shapeId) {
        return this.implicitErrors.contains(shapeId);
    }
}

