/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.framework.transform;

import java.util.HashSet;
import software.amazon.smithy.framework.traits.ImplicitErrorsTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.transform.ModelTransformer;

public final class AddFrameworkErrorsTransform {
    private static final String SMITHY_FRAMEWORK_NAMESPACE = "smithy.framework";
    private static final ShapeId SYNTHETIC_TRAIT_ID = ShapeId.from((String)"smithy.synthetic#frameworkErrors");

    private AddFrameworkErrorsTransform() {
    }

    public static Model transform(ModelTransformer transformer, Model model) {
        HashSet<ShapeId> frameworkErrors = new HashSet<ShapeId>();
        for (StructureShape struct : model.getStructureShapes()) {
            if (!struct.hasTrait(ErrorTrait.class) || !struct.getId().getNamespace().equals(SMITHY_FRAMEWORK_NAMESPACE)) continue;
            frameworkErrors.add(struct.getId());
        }
        ImplicitErrorsTrait addedFrameworkErrors = ImplicitErrorsTrait.builder().values(frameworkErrors.stream().toList()).build();
        StructureShape syntheticFrameworkTraitShape = ((StructureShape.Builder)AddFrameworkErrorsTransform.getSyntheticTraitBuilder().addTrait((Trait)addedFrameworkErrors)).build();
        HashSet<Object> updated = new HashSet<Object>();
        updated.add(syntheticFrameworkTraitShape);
        for (ServiceShape service : model.getServiceShapes()) {
            updated.add(((ServiceShape.Builder)service.toBuilder().addTrait((Trait)new SyntheticErrorTrait())).build());
        }
        return transformer.replaceShapes(model, updated);
    }

    private static StructureShape.Builder getSyntheticTraitBuilder() {
        return (StructureShape.Builder)((StructureShape.Builder)StructureShape.builder().id(SYNTHETIC_TRAIT_ID)).addTrait((Trait)TraitDefinition.builder().build());
    }

    private static final class SyntheticErrorTrait
    implements Trait {
        private SyntheticErrorTrait() {
        }

        public Node toNode() {
            return Node.objectNode();
        }

        public ShapeId toShapeId() {
            return SYNTHETIC_TRAIT_ID;
        }

        public boolean isSynthetic() {
            return true;
        }
    }
}

