/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.java.framework.model;

import java.util.Objects;
import software.amazon.smithy.java.core.error.ErrorFault;
import software.amazon.smithy.java.core.error.ModeledException;
import software.amazon.smithy.java.core.schema.Schema;
import software.amazon.smithy.java.core.schema.SchemaUtils;
import software.amazon.smithy.java.core.schema.SerializableShape;
import software.amazon.smithy.java.core.schema.ShapeBuilder;
import software.amazon.smithy.java.core.serde.ShapeDeserializer;
import software.amazon.smithy.java.core.serde.ShapeSerializer;
import software.amazon.smithy.java.core.serde.ToStringSerializer;
import software.amazon.smithy.java.framework.model.InternalFailureException$Builder$;
import software.amazon.smithy.java.framework.model.Schemas;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.SmithyGenerated;

@SmithyGenerated
public final class InternalFailureException
extends ModeledException {
    public static final Schema $SCHEMA = Schemas.INTERNAL_FAILURE_EXCEPTION;
    private static final Schema $SCHEMA_MESSAGE = $SCHEMA.member("message");
    public static final ShapeId $ID = $SCHEMA.id();

    private InternalFailureException(Builder builder) {
        super($SCHEMA, builder.message, builder.$cause, ErrorFault.SERVER, builder.$captureStackTrace, builder.$deserialized);
    }

    public String toString() {
        return ToStringSerializer.serialize((SerializableShape)this);
    }

    public void serializeMembers(ShapeSerializer serializer) {
        serializer.writeString($SCHEMA_MESSAGE, this.getMessage());
    }

    public <T> T getMemberValue(Schema member) {
        switch (member.memberIndex()) {
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Attempted to get non-existent member: " + member.id());
            }
        }
        return (T)SchemaUtils.validateSameMember((Schema)$SCHEMA_MESSAGE, (Schema)member, (Object)this.getMessage());
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.message(this.getMessage());
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements ShapeBuilder<InternalFailureException> {
        private static final String MESSAGE_DEFAULT = "Internal Service Exception";
        private String message = "Internal Service Exception";
        private Throwable $cause;
        private Boolean $captureStackTrace;
        private boolean $deserialized;

        private Builder() {
        }

        public Schema schema() {
            return $SCHEMA;
        }

        public Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message cannot be null");
            return this;
        }

        public Builder withStackTrace() {
            this.$captureStackTrace = true;
            return this;
        }

        public Builder withoutStackTrace() {
            this.$captureStackTrace = false;
            return this;
        }

        public Builder withCause(Throwable cause) {
            this.$cause = cause;
            return this;
        }

        public InternalFailureException build() {
            return new InternalFailureException(this);
        }

        public void setMemberValue(Schema member, Object value) {
            switch (member.memberIndex()) {
                case 0: {
                    this.message((String)SchemaUtils.validateSameMember((Schema)$SCHEMA_MESSAGE, (Schema)member, (Object)value));
                    break;
                }
                default: {
                    super.setMemberValue(member, value);
                }
            }
        }

        public Builder deserialize(ShapeDeserializer decoder) {
            this.$deserialized = true;
            decoder.readStruct($SCHEMA, (Object)this, (ShapeDeserializer.StructMemberConsumer)Builder$$InnerDeserializer.INSTANCE);
            return this;
        }

        public Builder deserializeMember(ShapeDeserializer decoder, Schema schema) {
            decoder.readStruct(schema.assertMemberTargetIs($SCHEMA), (Object)this, (ShapeDeserializer.StructMemberConsumer)Builder$$InnerDeserializer.INSTANCE);
            return this;
        }
    }
}

