/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.sessionize.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullable;
import software.xdev.sessionize.model.Status;

@JsonPropertyOrder(value={"id", "title", "description", "startsAt", "endsAt", "isServiceSession", "isPlenumSession", "categoryItems", "roomId", "liveUrl", "recordingUrl", "status"})
public class BaseSession {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private JsonNullable<String> description = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STARTS_AT = "startsAt";
    private OffsetDateTime startsAt;
    public static final String JSON_PROPERTY_ENDS_AT = "endsAt";
    private OffsetDateTime endsAt;
    public static final String JSON_PROPERTY_IS_SERVICE_SESSION = "isServiceSession";
    private Boolean isServiceSession;
    public static final String JSON_PROPERTY_IS_PLENUM_SESSION = "isPlenumSession";
    private Boolean isPlenumSession;
    public static final String JSON_PROPERTY_CATEGORY_ITEMS = "categoryItems";
    private List<Integer> categoryItems = new ArrayList<Integer>();
    public static final String JSON_PROPERTY_ROOM_ID = "roomId";
    private Integer roomId;
    public static final String JSON_PROPERTY_LIVE_URL = "liveUrl";
    private JsonNullable<URI> liveUrl = JsonNullable.undefined();
    public static final String JSON_PROPERTY_RECORDING_URL = "recordingUrl";
    private JsonNullable<URI> recordingUrl = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STATUS = "status";
    private Status status;

    public BaseSession id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public BaseSession title(String title) {
        this.title = title;
        return this;
    }

    @Nonnull
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTitle(String title) {
        this.title = title;
    }

    public BaseSession description(String description) {
        this.description = JsonNullable.of((Object)description);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getDescription() {
        return (String)this.description.orElse(null);
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDescription_JsonNullable() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription_JsonNullable(JsonNullable<String> description) {
        this.description = description;
    }

    public void setDescription(String description) {
        this.description = JsonNullable.of((Object)description);
    }

    public BaseSession startsAt(OffsetDateTime startsAt) {
        this.startsAt = startsAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="startsAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getStartsAt() {
        return this.startsAt;
    }

    @JsonProperty(value="startsAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartsAt(OffsetDateTime startsAt) {
        this.startsAt = startsAt;
    }

    public BaseSession endsAt(OffsetDateTime endsAt) {
        this.endsAt = endsAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="endsAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getEndsAt() {
        return this.endsAt;
    }

    @JsonProperty(value="endsAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndsAt(OffsetDateTime endsAt) {
        this.endsAt = endsAt;
    }

    public BaseSession isServiceSession(Boolean isServiceSession) {
        this.isServiceSession = isServiceSession;
        return this;
    }

    @Nonnull
    @JsonProperty(value="isServiceSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getIsServiceSession() {
        return this.isServiceSession;
    }

    @JsonProperty(value="isServiceSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIsServiceSession(Boolean isServiceSession) {
        this.isServiceSession = isServiceSession;
    }

    public BaseSession isPlenumSession(Boolean isPlenumSession) {
        this.isPlenumSession = isPlenumSession;
        return this;
    }

    @Nonnull
    @JsonProperty(value="isPlenumSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getIsPlenumSession() {
        return this.isPlenumSession;
    }

    @JsonProperty(value="isPlenumSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIsPlenumSession(Boolean isPlenumSession) {
        this.isPlenumSession = isPlenumSession;
    }

    public BaseSession categoryItems(List<Integer> categoryItems) {
        this.categoryItems = categoryItems;
        return this;
    }

    public BaseSession addCategoryItemsItem(Integer categoryItemsItem) {
        if (this.categoryItems == null) {
            this.categoryItems = new ArrayList<Integer>();
        }
        this.categoryItems.add(categoryItemsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="categoryItems")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Integer> getCategoryItems() {
        return this.categoryItems;
    }

    @JsonProperty(value="categoryItems")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCategoryItems(List<Integer> categoryItems) {
        this.categoryItems = categoryItems;
    }

    public BaseSession roomId(Integer roomId) {
        this.roomId = roomId;
        return this;
    }

    @Nullable
    @JsonProperty(value="roomId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getRoomId() {
        return this.roomId;
    }

    @JsonProperty(value="roomId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomId(Integer roomId) {
        this.roomId = roomId;
    }

    public BaseSession liveUrl(URI liveUrl) {
        this.liveUrl = JsonNullable.of((Object)liveUrl);
        return this;
    }

    @Nullable
    @JsonIgnore
    public URI getLiveUrl() {
        return (URI)this.liveUrl.orElse(null);
    }

    @JsonProperty(value="liveUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<URI> getLiveUrl_JsonNullable() {
        return this.liveUrl;
    }

    @JsonProperty(value="liveUrl")
    public void setLiveUrl_JsonNullable(JsonNullable<URI> liveUrl) {
        this.liveUrl = liveUrl;
    }

    public void setLiveUrl(URI liveUrl) {
        this.liveUrl = JsonNullable.of((Object)liveUrl);
    }

    public BaseSession recordingUrl(URI recordingUrl) {
        this.recordingUrl = JsonNullable.of((Object)recordingUrl);
        return this;
    }

    @Nullable
    @JsonIgnore
    public URI getRecordingUrl() {
        return (URI)this.recordingUrl.orElse(null);
    }

    @JsonProperty(value="recordingUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<URI> getRecordingUrl_JsonNullable() {
        return this.recordingUrl;
    }

    @JsonProperty(value="recordingUrl")
    public void setRecordingUrl_JsonNullable(JsonNullable<URI> recordingUrl) {
        this.recordingUrl = recordingUrl;
    }

    public void setRecordingUrl(URI recordingUrl) {
        this.recordingUrl = JsonNullable.of((Object)recordingUrl);
    }

    public BaseSession status(Status status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Status getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseSession baseSession = (BaseSession)o;
        return Objects.equals(this.id, baseSession.id) && Objects.equals(this.title, baseSession.title) && BaseSession.equalsNullable(this.description, baseSession.description) && Objects.equals(this.startsAt, baseSession.startsAt) && Objects.equals(this.endsAt, baseSession.endsAt) && Objects.equals(this.isServiceSession, baseSession.isServiceSession) && Objects.equals(this.isPlenumSession, baseSession.isPlenumSession) && Objects.equals(this.categoryItems, baseSession.categoryItems) && Objects.equals(this.roomId, baseSession.roomId) && BaseSession.equalsNullable(this.liveUrl, baseSession.liveUrl) && BaseSession.equalsNullable(this.recordingUrl, baseSession.recordingUrl) && Objects.equals((Object)this.status, (Object)baseSession.status);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.title, BaseSession.hashCodeNullable(this.description), this.startsAt, this.endsAt, this.isServiceSession, this.isPlenumSession, this.categoryItems, this.roomId, BaseSession.hashCodeNullable(this.liveUrl), BaseSession.hashCodeNullable(this.recordingUrl), this.status});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseSession {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    startsAt: ").append(this.toIndentedString(this.startsAt)).append("\n");
        sb.append("    endsAt: ").append(this.toIndentedString(this.endsAt)).append("\n");
        sb.append("    isServiceSession: ").append(this.toIndentedString(this.isServiceSession)).append("\n");
        sb.append("    isPlenumSession: ").append(this.toIndentedString(this.isPlenumSession)).append("\n");
        sb.append("    categoryItems: ").append(this.toIndentedString(this.categoryItems)).append("\n");
        sb.append("    roomId: ").append(this.toIndentedString(this.roomId)).append("\n");
        sb.append("    liveUrl: ").append(this.toIndentedString(this.liveUrl)).append("\n");
        sb.append("    recordingUrl: ").append(this.toIndentedString(this.recordingUrl)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTitle() != null) {
            try {
                joiner.add(String.format("%stitle%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTitle()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDescription() != null) {
            try {
                joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getStartsAt() != null) {
            try {
                joiner.add(String.format("%sstartsAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStartsAt()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEndsAt() != null) {
            try {
                joiner.add(String.format("%sendsAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEndsAt()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getIsServiceSession() != null) {
            try {
                joiner.add(String.format("%sisServiceSession%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getIsServiceSession()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getIsPlenumSession() != null) {
            try {
                joiner.add(String.format("%sisPlenumSession%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getIsPlenumSession()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCategoryItems() != null) {
            for (int i = 0; i < this.getCategoryItems().size(); ++i) {
                try {
                    joiner.add(String.format("%scategoryItems%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getCategoryItems().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getRoomId() != null) {
            try {
                joiner.add(String.format("%sroomId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRoomId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getLiveUrl() != null) {
            try {
                joiner.add(String.format("%sliveUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLiveUrl()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getRecordingUrl() != null) {
            try {
                joiner.add(String.format("%srecordingUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRecordingUrl()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getStatus() != null) {
            try {
                joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getStatus()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

