/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.sessionize.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;

@JsonPropertyOrder(value={"id", "firstName", "lastName", "email"})
public class SpeakerWithEmail {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private UUID id;
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    @Nonnull
    private String firstName;
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    @Nonnull
    private String lastName;
    public static final String JSON_PROPERTY_EMAIL = "email";
    @Nonnull
    private String email;

    public SpeakerWithEmail id(@Nonnull UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull UUID id) {
        this.id = id;
    }

    public SpeakerWithEmail firstName(@Nonnull String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFirstName(@Nonnull String firstName) {
        this.firstName = firstName;
    }

    public SpeakerWithEmail lastName(@Nonnull String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLastName(@Nonnull String lastName) {
        this.lastName = lastName;
    }

    public SpeakerWithEmail email(@Nonnull String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(@Nonnull String email) {
        this.email = email;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpeakerWithEmail speakerWithEmail = (SpeakerWithEmail)o;
        return Objects.equals(this.id, speakerWithEmail.id) && Objects.equals(this.firstName, speakerWithEmail.firstName) && Objects.equals(this.lastName, speakerWithEmail.lastName) && Objects.equals(this.email, speakerWithEmail.email);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.firstName, this.lastName, this.email);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SpeakerWithEmail {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getFirstName() != null) {
            try {
                joiner.add(String.format("%sfirstName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFirstName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getLastName() != null) {
            try {
                joiner.add(String.format("%slastName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLastName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEmail() != null) {
            try {
                joiner.add(String.format("%semail%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEmail()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

