/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.sessionize.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"questionId", "answerValue"})
public class QuestionAnswer {
    public static final String JSON_PROPERTY_QUESTION_ID = "questionId";
    @Nonnull
    private Integer questionId;
    public static final String JSON_PROPERTY_ANSWER_VALUE = "answerValue";
    @Nonnull
    private String answerValue;

    public QuestionAnswer questionId(@Nonnull Integer questionId) {
        this.questionId = questionId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="questionId", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getQuestionId() {
        return this.questionId;
    }

    @JsonProperty(value="questionId", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuestionId(@Nonnull Integer questionId) {
        this.questionId = questionId;
    }

    public QuestionAnswer answerValue(@Nonnull String answerValue) {
        this.answerValue = answerValue;
        return this;
    }

    @Nonnull
    @JsonProperty(value="answerValue", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAnswerValue() {
        return this.answerValue;
    }

    @JsonProperty(value="answerValue", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAnswerValue(@Nonnull String answerValue) {
        this.answerValue = answerValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuestionAnswer questionAnswer = (QuestionAnswer)o;
        return Objects.equals(this.questionId, questionAnswer.questionId) && Objects.equals(this.answerValue, questionAnswer.answerValue);
    }

    public int hashCode() {
        return Objects.hash(this.questionId, this.answerValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QuestionAnswer {\n");
        sb.append("    questionId: ").append(this.toIndentedString(this.questionId)).append("\n");
        sb.append("    answerValue: ").append(this.toIndentedString(this.answerValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getQuestionId() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%squestionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getQuestionId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAnswerValue() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%sanswerValue%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAnswerValue()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

