/*
 * Decompiled with CFR 0.152.
 */
package dev.secondsun.geometry.playfield;

import dev.secondsun.geometry.Model;
import dev.secondsun.geometry.Triangle;
import dev.secondsun.geometry.Vertex;
import dev.secondsun.geometry.Vertex2D;
import dev.secondsun.util.BSPTree;
import dev.secondsun.util.BoundedCube;
import dev.secondsun.util.CubeBuilder;
import dev.secondsun.util.Resources;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class DormRoom
implements Model {
    private static final int TILE_LENGTH = 16;
    private final BSPTree root;
    private List<Triangle> triangles = new ArrayList<Triangle>();
    private static final Integer woodId1;
    private static final Integer woodId2;
    private static final Integer booksId1;
    private static final Integer booksId2;
    private static final int floorId2;
    private static final int floorId1;
    private static final int bedId2;
    private static final int bedId1;
    private static final int bedUpId2;
    private static final int bedUpId1;
    private ArrayList<Triangle> floorTris;
    private ArrayList<Triangle> mattressTries;
    private ArrayList<Triangle> bookshelfTriangles;
    private ArrayList<Triangle> bedLegsTriangles;
    private ArrayList<Triangle> bedTries;

    public DormRoom() {
        this.bookshelf();
        this.bed();
        this.floor();
        this.root = new BSPTree();
        this.root.add(new BoundedCube(this.floorModel()));
        this.root.add(new BoundedCube(this.bookshelfModel()));
        this.root.add(new BoundedCube(this.bedModel()));
    }

    private void floor() {
        this.floorTris = new ArrayList();
        this.floorTris.add(new Triangle(new Vertex(0.0f, 0.0f, 0.0f), new Vertex(0.0f, 96.0f, 0.0f), new Vertex(96.0f, 96.0f, 0.0f), floorId1));
        this.floorTris.add(new Triangle(new Vertex(96.0f, 96.0f, 0.0f), new Vertex(96.0f, 0.0f, 0.0f), new Vertex(0.0f, 0.0f, 0.0f), floorId2));
        this.triangles.addAll(this.floorTris);
    }

    private void bookshelf() {
        this.bookshelfTriangles = new ArrayList();
        CubeBuilder builder = new CubeBuilder(new Vertex(0.0f, 32.0f, 0.0f), 16.0f, 36.0f, 48.0f);
        builder.setBottom1(woodId1).setBottom2(woodId2).setTop1(woodId1).setTop2(woodId2).setFront1(booksId1).setFront2(booksId2).setBack1(booksId1).setBack2(booksId2).setUp1(woodId1).setUp2(woodId2).disableDown();
        this.bookshelfTriangles.addAll(builder.cube().getTriangles());
        this.triangles.addAll(this.bookshelfTriangles);
    }

    private void bed() {
        this.mattress();
        this.legs();
        this.bedTries = new ArrayList();
        this.bedTries.addAll(this.mattressTries);
        this.bedTries.addAll(this.bedLegsTriangles);
    }

    private void mattress() {
        this.mattressTries = new ArrayList();
        CubeBuilder builder = new CubeBuilder(new Vertex(16.0f, 0.0f, 12.0f), 32.0f, 4.0f, 16.0f);
        builder.setBottom1(bedId1).setBottom2(bedId2).setTop1(bedId1).setTop2(bedId2).setFront1(Color.WHITE.getRGB()).setFront2(Color.WHITE.getRGB()).setBack1(Color.cyan.getRGB()).setBack2(Color.cyan.getRGB()).setUp1(bedUpId1).setUp2(bedUpId2).disableDown();
        this.mattressTries.addAll(builder.cube().getTriangles());
        this.triangles.addAll(this.mattressTries);
    }

    private void legs() {
        this.bedLegsTriangles = new ArrayList();
        CubeBuilder builder = new CubeBuilder(new Vertex(20.0f, 4.0f, 0.0f), 4.0f, 12.0f, 4.0f);
        builder.setBottom1(10506797).setBottom2(10506797).setTop1(10506797).setTop2(10506797).setFront1(10506797).setFront2(10506797).setBack1(10506797).setBack2(10506797).setUp1(10506797).setUp2(10506797).disableUp().disableDown();
        this.bedLegsTriangles.addAll(builder.cube().getTriangles());
        builder = new CubeBuilder(new Vertex(20.0f, 12.0f, 0.0f), 4.0f, 12.0f, 4.0f);
        builder.setBottom1(10506797).setBottom2(10506797).setTop1(10506797).setTop2(10506797).setFront1(10506797).setFront2(10506797).setBack1(10506797).setBack2(10506797).setUp1(10506797).setUp2(10506797).disableUp().disableDown();
        this.bedLegsTriangles.addAll(builder.cube().getTriangles());
        builder = new CubeBuilder(new Vertex(44.0f, 4.0f, 0.0f), 4.0f, 12.0f, 4.0f);
        builder.setBottom1(10506797).setBottom2(10506797).setTop1(10506797).setTop2(10506797).setFront1(10506797).setFront2(10506797).setBack1(10506797).setBack2(10506797).setUp1(10506797).setUp2(10506797).disableUp().disableDown();
        this.bedLegsTriangles.addAll(builder.cube().getTriangles());
        builder = new CubeBuilder(new Vertex(44.0f, 12.0f, 0.0f), 4.0f, 12.0f, 4.0f);
        builder.setBottom1(10506797).setBottom2(10506797).setTop1(10506797).setTop2(10506797).setFront1(10506797).setFront2(10506797).setBack1(10506797).setBack2(10506797).setUp1(10506797).setUp2(10506797).disableUp().disableDown();
        this.bedLegsTriangles.addAll(builder.cube().getTriangles());
        this.triangles.addAll(this.bedLegsTriangles);
    }

    @Override
    public List<Triangle> getTriangles() {
        return this.triangles;
    }

    @Override
    public BSPTree getBSPTree() {
        return this.root;
    }

    public Model bedModel() {
        return new Model(){

            @Override
            public List<Triangle> getTriangles() {
                return DormRoom.this.bedTries;
            }

            @Override
            public BSPTree getBSPTree() {
                return null;
            }
        };
    }

    public Model bookshelfModel() {
        return new Model(){

            @Override
            public List<Triangle> getTriangles() {
                return DormRoom.this.bookshelfTriangles;
            }

            @Override
            public BSPTree getBSPTree() {
                return null;
            }
        };
    }

    public Model floorModel() {
        return new Model(){

            @Override
            public List<Triangle> getTriangles() {
                return DormRoom.this.floorTris;
            }

            @Override
            public BSPTree getBSPTree() {
                return null;
            }
        };
    }

    static {
        try {
            int woodID = Resources.setImage(ImageIO.read(DormRoom.class.getClassLoader().getResourceAsStream("dormroom/wood.png")));
            int booksID = Resources.setImage(ImageIO.read(DormRoom.class.getClassLoader().getResourceAsStream("dormroom/books.png")));
            int floorID = Resources.setImage(ImageIO.read(DormRoom.class.getClassLoader().getResourceAsStream("dormroom/floor.png")));
            int bedID = Resources.setImage(ImageIO.read(DormRoom.class.getClassLoader().getResourceAsStream("dormroom/bed.png")));
            int bedUpID = Resources.setImage(ImageIO.read(DormRoom.class.getClassLoader().getResourceAsStream("dormroom/bedUp.png")));
            woodId1 = Resources.setTexture(woodID, new Vertex2D(0.0f, 0.0f), 15, 15);
            woodId2 = Resources.setTexture(woodID, new Vertex2D(15.0f, 15.0f), -15, -15);
            booksId1 = Resources.setTexture(booksID, new Vertex2D(0.0f, 0.0f), 32, 47);
            booksId2 = Resources.setTexture(booksID, new Vertex2D(32.0f, 47.0f), -32, -47);
            floorId1 = Resources.setTexture(floorID, new Vertex2D(0.0f, 0.0f), 100, 100);
            floorId2 = Resources.setTexture(floorID, new Vertex2D(100.0f, 100.0f), -100, -100);
            bedId1 = Resources.setTexture(bedID, new Vertex2D(0.0f, 0.0f), 15, 31);
            bedId2 = Resources.setTexture(bedID, new Vertex2D(15.0f, 31.0f), -15, -31);
            bedUpId1 = Resources.setTexture(bedUpID, new Vertex2D(0.0f, 0.0f), 31, 15);
            bedUpId2 = Resources.setTexture(bedUpID, new Vertex2D(31.0f, 15.0f), -31, -15);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

