/*
 * Decompiled with CFR 0.152.
 */
package dev.secondsun.geometry;

import dev.secondsun.geometry.Camera;
import dev.secondsun.geometry.Triangle;
import dev.secondsun.geometry.Vertex2D;
import dev.secondsun.util.BSPTree;
import java.util.List;

public interface Model {
    public static Model of(final List<Triangle> tris) {
        return new Model(){

            @Override
            public List<Triangle> getTriangles() {
                return tris;
            }

            @Override
            public BSPTree getBSPTree() {
                return new BSPTree(new BSPTree.Node());
            }
        };
    }

    public List<Triangle> getTriangles();

    public BSPTree getBSPTree();

    default public Model rotateY(int rotY) {
        this.getTriangles().forEach(tile -> tile.rotateY(rotY));
        return this;
    }

    default public Model rotateX(int rotX) {
        this.getTriangles().forEach(tile -> tile.rotateX(rotX));
        return this;
    }

    default public Model translateX(int i) {
        this.getTriangles().forEach(tile -> tile.translateX(i));
        return this;
    }

    default public Model translateY(int i) {
        this.getTriangles().forEach(tile -> tile.translateY(i));
        return this;
    }

    default public Model translateZ(int i) {
        this.getTriangles().forEach(tile -> tile.translateZ(i));
        return this;
    }

    default public Model scale(float v) {
        this.getTriangles().forEach(tile -> tile.scale(v));
        return this;
    }

    default public Model rotateZ(int i) {
        this.getTriangles().forEach(tile -> tile.rotateZ(i));
        return this;
    }

    default public Model lookAt(Camera camera, Vertex2D foV, Vertex2D worldCenter) {
        float[][] lookAt = camera.lookAt();
        float[][] fovMatrix = new float[][]{{foV.x, 0.0f, worldCenter.x}, {0.0f, foV.y, worldCenter.y}, {0.0f, 0.0f, 1.0f}};
        this.getTriangles().forEach(tile -> tile.transform(lookAt));
        this.getTriangles().forEach(tile -> tile.project(fovMatrix));
        return this;
    }
}

