/*
 * Decompiled with CFR 0.152.
 */
package dev.tinyflow.core.node;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.ChainNode;
import com.agentsflex.core.chain.ChainStatus;
import com.agentsflex.core.chain.Parameter;
import com.agentsflex.core.chain.RefType;
import com.agentsflex.core.chain.node.BaseNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoopNode
extends BaseNode {
    private Parameter loopVar;
    private Chain loopChain;

    public Parameter getLoopVar() {
        return this.loopVar;
    }

    public void setLoopVar(Parameter loopVar) {
        this.loopVar = loopVar;
    }

    public Chain getLoopChain() {
        return this.loopChain;
    }

    public void setLoopChain(Chain loopChain) {
        this.loopChain = loopChain;
    }

    protected Map<String, Object> execute(Chain chain) {
        HashMap<String, Object> executeResult;
        block3: {
            Object loopValue;
            Map chainMemory;
            block4: {
                this.loopChain.setParent(chain);
                this.loopChain.setStatus(ChainStatus.READY);
                executeResult = new HashMap<String, Object>();
                chainMemory = chain.getMemory().getAll();
                Map loopVars = chain.getParameterValues((ChainNode)this, Collections.singletonList(this.loopVar));
                loopValue = loopVars.get(this.loopVar.getName());
                if (!(loopValue instanceof Iterable)) break block4;
                Iterable iterable = (Iterable)loopValue;
                int index = 0;
                for (Object o : iterable) {
                    if (this.loopChain.getStatus() == ChainStatus.READY) {
                        this.executeLoopChain(index++, o, chainMemory, executeResult);
                        continue;
                    }
                    break block3;
                }
                break block3;
            }
            if (!(loopValue instanceof Number) && (!(loopValue instanceof String) || !this.isNumeric(loopValue.toString()))) break block3;
            int count = loopValue instanceof Number ? ((Number)loopValue).intValue() : Integer.parseInt(loopValue.toString().trim());
            for (int i = 0; i < count && this.loopChain.getStatus() == ChainStatus.READY; ++i) {
                this.executeLoopChain(i, i, chainMemory, executeResult);
            }
        }
        return executeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeLoopChain(int index, Object loopItem, Map<String, Object> parentMap, Map<String, Object> executeResult) {
        HashMap<String, Object> loopParams = new HashMap<String, Object>();
        loopParams.put(this.id + ".index", index);
        loopParams.put(this.id + ".loopItem", loopItem);
        loopParams.putAll(parentMap);
        try {
            this.loopChain.execute(loopParams);
        }
        finally {
            if (this.loopChain.getStatus() == ChainStatus.FINISHED_NORMAL) {
                this.fillResult(executeResult, this.loopChain);
                this.loopChain.reset();
            }
        }
    }

    private boolean isNumeric(String string) {
        char[] chars;
        if (string == null || string.isEmpty()) {
            return false;
        }
        for (char c : chars = string.trim().toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private void fillResult(Map<String, Object> executeResult, Chain loopChain) {
        List outputDefs = this.getOutputDefs();
        if (outputDefs != null) {
            for (Parameter outputDef : outputDefs) {
                Object value = null;
                if (outputDef.getRefType() == RefType.REF) {
                    value = loopChain.get(outputDef.getRef());
                } else if (outputDef.getRefType() == RefType.FIXED) {
                    value = outputDef.getValue();
                }
                ArrayList<Object> existList = (ArrayList<Object>)executeResult.get(outputDef.getName());
                if (existList == null) {
                    existList = new ArrayList<Object>();
                }
                existList.add(value);
                executeResult.put(outputDef.getName(), existList);
            }
        }
    }
}

