/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class AWTGlyphGeometryCache {
    protected static final int INITIAL_CAPACITY = 71;
    protected Entry[] table;
    protected int count;
    protected ReferenceQueue referenceQueue = new ReferenceQueue();

    public AWTGlyphGeometryCache() {
        this.table = new Entry[71];
    }

    public AWTGlyphGeometryCache(int c) {
        this.table = new Entry[c];
    }

    public int size() {
        return this.count;
    }

    public Value get(char c) {
        int hash2 = this.hashCode(c) & Integer.MAX_VALUE;
        int index2 = hash2 % this.table.length;
        Entry e = this.table[index2];
        while (e != null) {
            if (e.hash == hash2 && e.match(c)) {
                return (Value)e.get();
            }
            e = e.next;
        }
        return null;
    }

    public Value put(char c, Value value2) {
        int len;
        this.removeClearedEntries();
        int hash2 = this.hashCode(c) & Integer.MAX_VALUE;
        int index2 = hash2 % this.table.length;
        Entry e = this.table[index2];
        if (e != null) {
            if (e.hash == hash2 && e.match(c)) {
                Object old = e.get();
                this.table[index2] = new Entry(hash2, c, value2, e.next);
                return (Value)old;
            }
            Entry o = e;
            e = e.next;
            while (e != null) {
                if (e.hash == hash2 && e.match(c)) {
                    Object old = e.get();
                    o.next = e = new Entry(hash2, c, value2, e.next);
                    return (Value)old;
                }
                o = e;
                e = e.next;
            }
        }
        if (this.count++ >= (len = this.table.length) - (len >> 2)) {
            this.rehash();
            index2 = hash2 % this.table.length;
        }
        this.table[index2] = new Entry(hash2, c, value2, this.table[index2]);
        return null;
    }

    public void clear() {
        this.table = new Entry[71];
        this.count = 0;
        this.referenceQueue = new ReferenceQueue();
    }

    protected void rehash() {
        Entry[] oldTable = this.table;
        this.table = new Entry[oldTable.length * 2 + 1];
        for (int i = oldTable.length - 1; i >= 0; --i) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index2 = e.hash % this.table.length;
                e.next = this.table[index2];
                this.table[index2] = e;
            }
        }
    }

    protected int hashCode(char c) {
        return c;
    }

    protected void removeClearedEntries() {
        Entry e;
        while ((e = (Entry)this.referenceQueue.poll()) != null) {
            int index2 = e.hash % this.table.length;
            Entry t = this.table[index2];
            if (t == e) {
                this.table[index2] = e.next;
            } else {
                while (t != null) {
                    Entry c = t.next;
                    if (c == e) {
                        t.next = e.next;
                        break;
                    }
                    t = c;
                }
            }
            --this.count;
        }
    }

    protected class Entry
    extends SoftReference {
        public int hash;
        public char c;
        public Entry next;

        public Entry(int hash2, char c, Value value2, Entry next2) {
            super(value2, AWTGlyphGeometryCache.this.referenceQueue);
            this.hash = hash2;
            this.c = c;
            this.next = next2;
        }

        public boolean match(char o2) {
            return this.c == o2;
        }
    }

    public static class Value {
        protected Shape outline;
        protected Rectangle2D gmB;
        protected Rectangle2D outlineBounds;

        public Value(Shape outline, Rectangle2D gmB) {
            this.outline = outline;
            this.outlineBounds = outline.getBounds2D();
            this.gmB = gmB;
        }

        public Shape getOutline() {
            return this.outline;
        }

        public Rectangle2D getBounds2D() {
            return this.gmB;
        }

        public Rectangle2D getOutlineBounds2D() {
            return this.outlineBounds;
        }
    }
}

