/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.batik.svggen.DefaultErrorHandler;
import org.apache.batik.svggen.DefaultExtensionHandler;
import org.apache.batik.svggen.DefaultStyleHandler;
import org.apache.batik.svggen.ErrorConstants;
import org.apache.batik.svggen.ErrorHandler;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.GenericImageHandler;
import org.apache.batik.svggen.ImageHandler;
import org.apache.batik.svggen.ImageHandlerBase64Encoder;
import org.apache.batik.svggen.SVGGraphics2DRuntimeException;
import org.apache.batik.svggen.SVGIDGenerator;
import org.apache.batik.svggen.SimpleImageHandler;
import org.apache.batik.svggen.StyleHandler;
import org.w3c.dom.Document;

public class SVGGeneratorContext
implements ErrorConstants {
    Document domFactory;
    ImageHandler imageHandler;
    GenericImageHandler genericImageHandler;
    ExtensionHandler extensionHandler;
    SVGIDGenerator idGenerator;
    StyleHandler styleHandler;
    String generatorComment;
    ErrorHandler errorHandler;
    boolean svgFont = false;
    GraphicContextDefaults gcDefaults;
    int precision = 4;
    protected DecimalFormat decimalFormat = decimalFormats[this.precision];
    protected static DecimalFormatSymbols dsf = new DecimalFormatSymbols(Locale.US);
    protected static DecimalFormat[] decimalFormats = new DecimalFormat[13];

    protected SVGGeneratorContext(Document domFactory) {
        this.setDOMFactory(domFactory);
    }

    public static SVGGeneratorContext createDefault(Document domFactory) {
        SVGGeneratorContext ctx = new SVGGeneratorContext(domFactory);
        ctx.setIDGenerator(new SVGIDGenerator());
        ctx.setExtensionHandler(new DefaultExtensionHandler());
        ctx.setImageHandler(new ImageHandlerBase64Encoder());
        ctx.setStyleHandler(new DefaultStyleHandler());
        ctx.setComment("Generated by the Batik Graphics2D SVG Generator");
        ctx.setErrorHandler(new DefaultErrorHandler());
        return ctx;
    }

    public final GraphicContextDefaults getGraphicContextDefaults() {
        return this.gcDefaults;
    }

    public final void setGraphicContextDefaults(GraphicContextDefaults gcDefaults) {
        this.gcDefaults = gcDefaults;
    }

    public final SVGIDGenerator getIDGenerator() {
        return this.idGenerator;
    }

    public final void setIDGenerator(SVGIDGenerator idGenerator) {
        if (idGenerator == null) {
            throw new SVGGraphics2DRuntimeException("idGenerator should not be null");
        }
        this.idGenerator = idGenerator;
    }

    public final Document getDOMFactory() {
        return this.domFactory;
    }

    public final void setDOMFactory(Document domFactory) {
        if (domFactory == null) {
            throw new SVGGraphics2DRuntimeException("domFactory should not be null");
        }
        this.domFactory = domFactory;
    }

    public final ExtensionHandler getExtensionHandler() {
        return this.extensionHandler;
    }

    public final void setExtensionHandler(ExtensionHandler extensionHandler) {
        if (extensionHandler == null) {
            throw new SVGGraphics2DRuntimeException("extensionHandler should not be null");
        }
        this.extensionHandler = extensionHandler;
    }

    public final ImageHandler getImageHandler() {
        return this.imageHandler;
    }

    public final void setImageHandler(ImageHandler imageHandler) {
        if (imageHandler == null) {
            throw new SVGGraphics2DRuntimeException("imageHandler should not be null");
        }
        this.imageHandler = imageHandler;
        this.genericImageHandler = new SimpleImageHandler(imageHandler);
    }

    public final void setGenericImageHandler(GenericImageHandler genericImageHandler) {
        if (genericImageHandler == null) {
            throw new SVGGraphics2DRuntimeException("imageHandler should not be null");
        }
        this.imageHandler = null;
        this.genericImageHandler = genericImageHandler;
    }

    public final StyleHandler getStyleHandler() {
        return this.styleHandler;
    }

    public final void setStyleHandler(StyleHandler styleHandler) {
        if (styleHandler == null) {
            throw new SVGGraphics2DRuntimeException("styleHandler should not be null");
        }
        this.styleHandler = styleHandler;
    }

    public final String getComment() {
        return this.generatorComment;
    }

    public final void setComment(String generatorComment) {
        this.generatorComment = generatorComment;
    }

    public final ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public final void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new SVGGraphics2DRuntimeException("errorHandler should not be null");
        }
        this.errorHandler = errorHandler;
    }

    public final boolean isEmbeddedFontsOn() {
        return this.svgFont;
    }

    public final void setEmbeddedFontsOn(boolean svgFont) {
        this.svgFont = svgFont;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final void setPrecision(int precision) {
        this.precision = precision < 0 ? 0 : (precision > 12 ? 12 : precision);
        this.decimalFormat = decimalFormats[this.precision];
    }

    public final String doubleString(double value2) {
        double absvalue = Math.abs(value2);
        if (absvalue >= 1.0E8 || (double)((int)value2) == value2) {
            return Integer.toString((int)value2);
        }
        return this.decimalFormat.format(value2);
    }

    static {
        SVGGeneratorContext.decimalFormats[0] = new DecimalFormat("#", dsf);
        String format2 = "#.";
        for (int i = 1; i < decimalFormats.length; ++i) {
            format2 = format2 + "#";
            SVGGeneratorContext.decimalFormats[i] = new DecimalFormat(format2, dsf);
        }
    }

    public static class GraphicContextDefaults {
        protected Paint paint;
        protected Stroke stroke;
        protected Composite composite;
        protected Shape clip;
        protected RenderingHints hints;
        protected Font font;
        protected Color background;

        public void setStroke(Stroke stroke) {
            this.stroke = stroke;
        }

        public Stroke getStroke() {
            return this.stroke;
        }

        public void setComposite(Composite composite) {
            this.composite = composite;
        }

        public Composite getComposite() {
            return this.composite;
        }

        public void setClip(Shape clip) {
            this.clip = clip;
        }

        public Shape getClip() {
            return this.clip;
        }

        public void setRenderingHints(RenderingHints hints) {
            this.hints = hints;
        }

        public RenderingHints getRenderingHints() {
            return this.hints;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public Font getFont() {
            return this.font;
        }

        public void setBackground(Color background) {
            this.background = background;
        }

        public Color getBackground() {
            return this.background;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }

        public Paint getPaint() {
            return this.paint;
        }
    }
}

