/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ClassFileUtilities {
    public static final byte CONSTANT_UTF8_INFO = 1;
    public static final byte CONSTANT_INTEGER_INFO = 3;
    public static final byte CONSTANT_FLOAT_INFO = 4;
    public static final byte CONSTANT_LONG_INFO = 5;
    public static final byte CONSTANT_DOUBLE_INFO = 6;
    public static final byte CONSTANT_CLASS_INFO = 7;
    public static final byte CONSTANT_STRING_INFO = 8;
    public static final byte CONSTANT_FIELDREF_INFO = 9;
    public static final byte CONSTANT_METHODREF_INFO = 10;
    public static final byte CONSTANT_INTERFACEMETHODREF_INFO = 11;
    public static final byte CONSTANT_NAMEANDTYPE_INFO = 12;

    protected ClassFileUtilities() {
    }

    public static void main(String[] args) {
        boolean showFiles = false;
        if (args.length == 1 && args[0].equals("-f")) {
            showFiles = true;
        } else if (args.length != 0) {
            System.err.println("usage: org.apache.batik.util.ClassFileUtilities [-f]");
            System.err.println();
            System.err.println("  -f    list files that cause each jar file dependency");
            System.exit(1);
        }
        File cwd = new File(".");
        File buildDir = null;
        String[] cwdFiles = cwd.list();
        for (int i = 0; i < cwdFiles.length; ++i) {
            if (!cwdFiles[i].startsWith("batik-")) continue;
            buildDir = new File(cwdFiles[i]);
            if (buildDir.isDirectory()) break;
            buildDir = null;
        }
        if (buildDir == null || !buildDir.isDirectory()) {
            System.out.println("Directory 'batik-xxx' not found in current directory!");
            return;
        }
        try {
            Iterator<Object> j;
            ClassFile fromFile2;
            HashMap cs = new HashMap();
            HashMap js = new HashMap();
            ClassFileUtilities.collectJars(buildDir, js, cs);
            HashSet<JarFile> classpath = new HashSet<JarFile>();
            Iterator<Object> i = js.values().iterator();
            while (i.hasNext()) {
                classpath.add(((Jar)i.next()).jarFile);
            }
            i = cs.values().iterator();
            while (i.hasNext()) {
                fromFile2 = (ClassFile)i.next();
                Set result2 = ClassFileUtilities.getClassDependencies(fromFile2.getInputStream(), classpath, false);
                j = result2.iterator();
                while (j.hasNext()) {
                    ClassFile toFile = (ClassFile)cs.get(j.next());
                    if (fromFile2 == toFile || toFile == null) continue;
                    fromFile2.deps.add(toFile);
                }
            }
            i = cs.values().iterator();
            while (i.hasNext()) {
                fromFile2 = (ClassFile)i.next();
                Iterator j2 = fromFile2.deps.iterator();
                while (j2.hasNext()) {
                    ClassFile toFile = (ClassFile)j2.next();
                    Jar fromJar = fromFile2.jar;
                    Jar toJar = toFile.jar;
                    if (fromFile2.name.equals(toFile.name) || toJar == fromJar || fromJar.files.contains(toFile.name)) continue;
                    Integer n = (Integer)fromJar.deps.get(toJar);
                    if (n == null) {
                        fromJar.deps.put(toJar, new Integer(1));
                        continue;
                    }
                    fromJar.deps.put(toJar, new Integer(n + 1));
                }
            }
            ArrayList<Triple> triples = new ArrayList<Triple>(10);
            i = js.values().iterator();
            while (i.hasNext()) {
                Jar fromJar = (Jar)i.next();
                j = fromJar.deps.keySet().iterator();
                while (j.hasNext()) {
                    Jar toJar = (Jar)j.next();
                    Triple t = new Triple();
                    t.from = fromJar;
                    t.to = toJar;
                    t.count = (Integer)fromJar.deps.get(toJar);
                    triples.add(t);
                }
            }
            Collections.sort(triples);
            i = triples.iterator();
            while (i.hasNext()) {
                Triple t = (Triple)i.next();
                System.out.println(t.count + "," + t.from.name + "," + t.to.name);
                if (!showFiles) continue;
                j = t.from.files.iterator();
                while (j.hasNext()) {
                    ClassFile fromFile3 = (ClassFile)j.next();
                    Iterator k = fromFile3.deps.iterator();
                    while (k.hasNext()) {
                        ClassFile toFile = (ClassFile)k.next();
                        if (toFile.jar != t.to || t.from.files.contains(toFile.name)) continue;
                        System.out.println("\t" + fromFile3.name + " --> " + toFile.name);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void collectJars(File dir, Map jars, Map classFiles) throws IOException {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String n = files[i].getName();
            if (n.endsWith(".jar") && files[i].isFile()) {
                Jar j = new Jar();
                j.name = files[i].getPath();
                j.file = files[i];
                j.jarFile = new JarFile(files[i]);
                jars.put(j.name, j);
                Enumeration<JarEntry> entries = j.jarFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry ze = entries.nextElement();
                    String name = ze.getName();
                    if (!name.endsWith(".class")) continue;
                    ClassFile cf = new ClassFile();
                    cf.name = name;
                    cf.jar = j;
                    classFiles.put(j.name + '!' + cf.name, cf);
                    j.files.add(cf);
                }
                continue;
            }
            if (!files[i].isDirectory()) continue;
            ClassFileUtilities.collectJars(files[i], jars, classFiles);
        }
    }

    public static Set getClassDependencies(String path, Set classpath, boolean rec) throws IOException {
        return ClassFileUtilities.getClassDependencies(new FileInputStream(path), classpath, rec);
    }

    public static Set getClassDependencies(InputStream is, Set classpath, boolean rec) throws IOException {
        HashSet result2 = new HashSet();
        HashSet done = new HashSet();
        ClassFileUtilities.computeClassDependencies(is, classpath, done, result2, rec);
        return result2;
    }

    private static void computeClassDependencies(InputStream is, Set classpath, Set done, Set result2, boolean rec) throws IOException {
        Iterator it = ClassFileUtilities.getClassDependencies(is).iterator();
        while (it.hasNext()) {
            String s2 = (String)it.next();
            if (done.contains(s2)) continue;
            done.add(s2);
            Iterator cpit = classpath.iterator();
            while (cpit.hasNext()) {
                InputStream depis = null;
                String path = null;
                Object cpEntry = cpit.next();
                if (cpEntry instanceof JarFile) {
                    JarFile jarFile = (JarFile)cpEntry;
                    String classFileName = s2 + ".class";
                    ZipEntry ze = jarFile.getEntry(classFileName);
                    if (ze != null) {
                        path = jarFile.getName() + '!' + classFileName;
                        depis = jarFile.getInputStream(ze);
                    }
                } else {
                    path = (String)cpEntry + '/' + s2 + ".class";
                    File f = new File(path);
                    if (f.isFile()) {
                        depis = new FileInputStream(f);
                    }
                }
                if (depis == null) continue;
                result2.add(path);
                if (!rec) continue;
                ClassFileUtilities.computeClassDependencies(depis, classpath, done, result2, rec);
            }
        }
    }

    public static Set getClassDependencies(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        if (dis.readInt() != -889275714) {
            throw new IOException("Invalid classfile");
        }
        dis.readInt();
        int len = dis.readShort();
        String[] strs = new String[len];
        HashSet<Integer> classes = new HashSet<Integer>();
        HashSet<Integer> desc = new HashSet<Integer>();
        block8: for (int i = 1; i < len; ++i) {
            int constCode = dis.readByte() & 0xFF;
            switch (constCode) {
                case 5: 
                case 6: {
                    dis.readLong();
                    ++i;
                    continue block8;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: {
                    dis.readInt();
                    continue block8;
                }
                case 7: {
                    classes.add(new Integer(dis.readShort() & 0xFFFF));
                    continue block8;
                }
                case 8: {
                    dis.readShort();
                    continue block8;
                }
                case 12: {
                    dis.readShort();
                    desc.add(new Integer(dis.readShort() & 0xFFFF));
                    continue block8;
                }
                case 1: {
                    strs[i] = dis.readUTF();
                    continue block8;
                }
                default: {
                    throw new RuntimeException("unexpected data in constant-pool:" + constCode);
                }
            }
        }
        HashSet<String> result2 = new HashSet<String>();
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            result2.add(strs[(Integer)it.next()]);
        }
        it = desc.iterator();
        while (it.hasNext()) {
            result2.addAll(ClassFileUtilities.getDescriptorClasses(strs[(Integer)it.next()]));
        }
        return result2;
    }

    protected static Set getDescriptorClasses(String desc) {
        HashSet<String> result2 = new HashSet<String>();
        int i = 0;
        char c = desc.charAt(i);
        switch (c) {
            case '(': {
                StringBuffer sb;
                block14: while (true) {
                    c = desc.charAt(++i);
                    switch (c) {
                        case '[': {
                            while ((c = desc.charAt(++i)) == '[') {
                            }
                            if (c != 'L') continue block14;
                        }
                        case 'L': {
                            c = desc.charAt(++i);
                            sb = new StringBuffer();
                            while (c != ';') {
                                sb.append(c);
                                c = desc.charAt(++i);
                            }
                            result2.add(sb.toString());
                            continue block14;
                        }
                        default: {
                            continue block14;
                        }
                        case ')': 
                    }
                    break;
                }
                c = desc.charAt(++i);
                switch (c) {
                    case '[': {
                        while ((c = desc.charAt(++i)) == '[') {
                        }
                        if (c != 'L') break;
                    }
                    case 'L': {
                        c = desc.charAt(++i);
                        sb = new StringBuffer();
                        while (c != ';') {
                            sb.append(c);
                            c = desc.charAt(++i);
                        }
                        result2.add(sb.toString());
                        break;
                    }
                }
                break;
            }
            case '[': {
                while ((c = desc.charAt(++i)) == '[') {
                }
                if (c != 'L') break;
            }
            case 'L': {
                c = desc.charAt(++i);
                StringBuffer sb = new StringBuffer();
                while (c != ';') {
                    sb.append(c);
                    c = desc.charAt(++i);
                }
                result2.add(sb.toString());
                break;
            }
        }
        return result2;
    }

    protected static class Triple
    implements Comparable {
        public Jar from;
        public Jar to;
        public int count;

        protected Triple() {
        }

        public int compareTo(Object o) {
            return ((Triple)o).count - this.count;
        }
    }

    protected static class Jar {
        public String name;
        public File file;
        public JarFile jarFile;
        public Map deps = new HashMap();
        public Set files = new HashSet();

        protected Jar() {
        }
    }

    protected static class ClassFile {
        public String name;
        public List deps = new ArrayList(10);
        public Jar jar;

        protected ClassFile() {
        }

        public InputStream getInputStream() throws IOException {
            return this.jar.jarFile.getInputStream(this.jar.jarFile.getEntry(this.name));
        }
    }
}

