/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.modca.AbstractAFPObject;
import org.apache.fop.afp.util.BinaryUtils;

public class ObjectAreaPosition
extends AbstractAFPObject {
    public static final byte REFCSYS_PAGE_SEGMENT_RELATIVE = 0;
    public static final byte REFCSYS_PAGE_RELATIVE = 1;
    private final int x;
    private final int y;
    private final int rotation;
    private int xOffset;
    private int yOffset;
    private byte refCSys = 1;

    public ObjectAreaPosition(int x, int y, int rotation) {
        this(x, y, rotation, 1);
    }

    public ObjectAreaPosition(int x, int y, int rotation, byte refCSys) {
        this.x = x;
        this.y = y;
        this.rotation = rotation;
        this.setReferenceCoordinateSystem(refCSys);
    }

    public void setReferenceCoordinateSystem(byte refCSys) {
        this.refCSys = refCSys;
    }

    public void writeToStream(OutputStream os) throws IOException {
        byte yorient;
        byte xorient;
        byte[] data2 = new byte[33];
        this.copySF(data2, (byte)-84, (byte)107);
        byte[] len = BinaryUtils.convert(32, 2);
        data2[1] = len[0];
        data2[2] = len[1];
        data2[9] = 1;
        data2[10] = 23;
        byte[] xcoord = BinaryUtils.convert(this.x, 3);
        data2[11] = xcoord[0];
        data2[12] = xcoord[1];
        data2[13] = xcoord[2];
        byte[] ycoord = BinaryUtils.convert(this.y, 3);
        data2[14] = ycoord[0];
        data2[15] = ycoord[1];
        data2[16] = ycoord[2];
        data2[17] = xorient = (byte)(this.rotation / 2);
        data2[19] = yorient = (byte)(this.rotation / 2 + 45);
        byte[] xoffset = BinaryUtils.convert(this.xOffset, 3);
        data2[22] = xoffset[0];
        data2[23] = xoffset[1];
        data2[24] = xoffset[2];
        byte[] yoffset = BinaryUtils.convert(this.yOffset, 3);
        data2[25] = yoffset[0];
        data2[26] = yoffset[1];
        data2[27] = yoffset[2];
        data2[28] = 0;
        data2[29] = 0;
        data2[30] = 45;
        data2[31] = 0;
        data2[32] = this.refCSys;
        os.write(data2);
    }

    public String toString() {
        return "ObjectAreaPosition{x=" + this.x + ", y=" + this.y + ", rotation=" + this.rotation + ", rotation=" + this.rotation + ", xOffset=" + this.xOffset + ", yOffset=" + this.yOffset;
    }
}

