/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.fop.afp.Streamable;
import org.apache.fop.afp.modca.AbstractNamedAFPObject;

public class ResourceGroup
extends AbstractNamedAFPObject {
    private final Set resourceSet = new HashSet();

    public ResourceGroup(String name) {
        super(name);
    }

    public void addObject(AbstractNamedAFPObject namedObject) throws IOException {
        this.resourceSet.add(namedObject);
    }

    public int getResourceCount() {
        return this.resourceSet.size();
    }

    public boolean resourceExists(String uri) {
        return this.resourceSet.contains(uri);
    }

    public void writeStart(OutputStream os) throws IOException {
        byte[] data2 = new byte[17];
        this.copySF(data2, (byte)-88, (byte)-58);
        os.write(data2);
    }

    public void writeContent(OutputStream os) throws IOException {
        for (Object object : this.resourceSet) {
            if (!(object instanceof Streamable)) continue;
            Streamable streamableObject = (Streamable)object;
            streamableObject.writeToStream(os);
        }
    }

    public void writeEnd(OutputStream os) throws IOException {
        byte[] data2 = new byte[17];
        this.copySF(data2, (byte)-87, (byte)-58);
        os.write(data2);
    }

    public String toString() {
        return this.name + " " + this.resourceSet;
    }
}

