/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;

public class GlyphMappingTable {
    public static final int GLYPH_MAPPING_TYPE_EMPTY = 0;
    public static final int GLYPH_MAPPING_TYPE_MAPPED = 1;
    public static final int GLYPH_MAPPING_TYPE_RANGE = 2;

    public int getType() {
        return -1;
    }

    public List getEntries() {
        return null;
    }

    public int getMappingSize() {
        return 0;
    }

    public int getMappedIndex(int gid) {
        return -1;
    }

    public static class MappingRange {
        private final int gidStart;
        private final int gidEnd;
        private final int index;

        public MappingRange() {
            this(0, 0, 0);
        }

        public MappingRange(int gidStart, int gidEnd, int index2) {
            if (gidStart < 0 || gidEnd < 0 || index2 < 0) {
                throw new AdvancedTypographicTableFormatException();
            }
            if (gidStart > gidEnd) {
                throw new AdvancedTypographicTableFormatException();
            }
            this.gidStart = gidStart;
            this.gidEnd = gidEnd;
            this.index = index2;
        }

        public int getStart() {
            return this.gidStart;
        }

        public int getEnd() {
            return this.gidEnd;
        }

        public int getIndex() {
            return this.index;
        }

        public int[] getInterval() {
            return new int[]{this.gidStart, this.gidEnd};
        }

        public int[] getInterval(int[] interval) {
            if (interval == null || interval.length != 2) {
                throw new IllegalArgumentException();
            }
            interval[0] = this.gidStart;
            interval[1] = this.gidEnd;
            return interval;
        }

        public int getLength() {
            return this.gidStart - this.gidEnd;
        }
    }

    protected static abstract class RangeMappingTable
    extends GlyphMappingTable {
        private int[] sa = null;
        private int[] ea = null;
        private int[] ma = null;
        private int miMax = -1;

        public RangeMappingTable(List entries) {
            this.populate(entries);
        }

        public int getType() {
            return 2;
        }

        public List getEntries() {
            ArrayList<MappingRange> entries = new ArrayList<MappingRange>();
            if (this.sa != null) {
                int n = this.sa.length;
                for (int i = 0; i < n; ++i) {
                    entries.add(new MappingRange(this.sa[i], this.ea[i], this.ma[i]));
                }
            }
            return entries;
        }

        public int getMappingSize() {
            return this.miMax + 1;
        }

        public int getMappedIndex(int gid) {
            int i = Arrays.binarySearch(this.sa, gid);
            int mi = i >= 0 ? this.getMappedIndex(gid, this.sa[i], this.ma[i]) : ((i = -(i + 1)) == 0 ? -1 : (gid > this.ea[--i] ? -1 : this.getMappedIndex(gid, this.sa[i], this.ma[i])));
            return mi;
        }

        public abstract int getMappedIndex(int var1, int var2, int var3);

        private void populate(List entries) {
            int i = 0;
            int n = entries.size();
            int gidMax = -1;
            int miMax = -1;
            int[] sa = new int[n];
            int[] ea = new int[n];
            int[] ma = new int[n];
            for (Object o : entries) {
                if (o instanceof MappingRange) {
                    MappingRange r = (MappingRange)o;
                    int gs = r.getStart();
                    int ge = r.getEnd();
                    int mi = r.getIndex();
                    if (gs < 0 || gs > 65535) {
                        throw new AdvancedTypographicTableFormatException("illegal glyph range: [" + gs + "," + ge + "]: bad start index");
                    }
                    if (ge < 0 || ge > 65535) {
                        throw new AdvancedTypographicTableFormatException("illegal glyph range: [" + gs + "," + ge + "]: bad end index");
                    }
                    if (gs > ge) {
                        throw new AdvancedTypographicTableFormatException("illegal glyph range: [" + gs + "," + ge + "]: start index exceeds end index");
                    }
                    if (gs < gidMax) {
                        throw new AdvancedTypographicTableFormatException("out of order glyph range: [" + gs + "," + ge + "]");
                    }
                    if (mi < 0) {
                        throw new AdvancedTypographicTableFormatException("illegal mapping index: " + mi);
                    }
                    sa[i] = gs;
                    ea[i] = gidMax = ge;
                    ma[i] = mi;
                    int miLast = mi + (ge - gs);
                    if (miLast > miMax) {
                        miMax = miLast;
                    }
                    ++i;
                    continue;
                }
                throw new AdvancedTypographicTableFormatException("illegal mapping entry, must be Integer: " + o);
            }
            assert (i == n);
            assert (this.sa == null);
            assert (this.ea == null);
            assert (this.ma == null);
            this.sa = sa;
            this.ea = ea;
            this.ma = ma;
            this.miMax = miMax;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            int n = this.sa.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append('[');
                sb.append(Integer.toString(this.sa[i]));
                sb.append(Integer.toString(this.ea[i]));
                sb.append("]:");
                sb.append(Integer.toString(this.ma[i]));
            }
            sb.append('}');
            return sb.toString();
        }
    }

    protected static class MappedMappingTable
    extends GlyphMappingTable {
        public int getType() {
            return 1;
        }
    }

    protected static class EmptyMappingTable
    extends GlyphMappingTable {
        public EmptyMappingTable() {
            this(null);
        }

        public EmptyMappingTable(List entries) {
        }

        public int getType() {
            return 0;
        }

        public List getEntries() {
            return new ArrayList();
        }

        public int getMappingSize() {
            return 0;
        }

        public int getMappedIndex(int gid) {
            return -1;
        }
    }
}

