/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFArray
extends PDFObject {
    protected List<Object> values = new ArrayList<Object>();

    public PDFArray(PDFObject parent) {
        super(parent);
    }

    public PDFArray() {
        this(null);
    }

    public PDFArray(PDFObject parent, int[] values) {
        super(parent);
        int c = values.length;
        for (int i = 0; i < c; ++i) {
            this.values.add(values[i]);
        }
    }

    public PDFArray(PDFObject parent, double[] values) {
        super(parent);
        int c = values.length;
        for (int i = 0; i < c; ++i) {
            this.values.add(new Double(values[i]));
        }
    }

    public PDFArray(PDFObject parent, List<?> values) {
        super(parent);
        this.values.addAll(values);
    }

    public PDFArray(Object ... elements) {
        this(null, elements);
    }

    public PDFArray(PDFObject parent, Object[] values) {
        super(parent);
        int c = values.length;
        for (int i = 0; i < c; ++i) {
            this.values.add(values[i]);
        }
    }

    public boolean contains(Object obj) {
        return this.values.contains(obj);
    }

    public int length() {
        return this.values.size();
    }

    public void set(int index2, Object obj) {
        this.values.set(index2, obj);
    }

    public void set(int index2, double value2) {
        this.values.set(index2, new Double(value2));
    }

    public Object get(int index2) {
        return this.values.get(index2);
    }

    public void add(Object obj) {
        PDFObject pdfObj;
        if (obj instanceof PDFObject && !(pdfObj = (PDFObject)obj).hasObjectNumber()) {
            pdfObj.setParent(this);
        }
        this.values.add(obj);
    }

    public void add(double value2) {
        this.values.add(new Double(value2));
    }

    public void clear() {
        this.values.clear();
    }

    @Override
    public int output(OutputStream stream) throws IOException {
        CountingOutputStream cout = new CountingOutputStream(stream);
        StringBuilder textBuffer = new StringBuilder(64);
        textBuffer.append('[');
        for (int i = 0; i < this.values.size(); ++i) {
            if (i > 0) {
                textBuffer.append(' ');
            }
            Object obj = this.values.get(i);
            this.formatObject(obj, cout, textBuffer);
        }
        textBuffer.append(']');
        PDFDocument.flushTextBuffer(textBuffer, cout);
        return cout.getCount();
    }
}

