/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.fop.pdf.ASCII85Filter;
import org.apache.fop.pdf.ASCIIHexFilter;
import org.apache.fop.pdf.FlateFilter;
import org.apache.fop.pdf.NullFilter;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFFilterList {
    public static final String DEFAULT_FILTER = "default";
    public static final String CONTENT_FILTER = "content";
    public static final String PRECOMPRESSED_FILTER = "precompressed";
    public static final String IMAGE_FILTER = "image";
    public static final String JPEG_FILTER = "jpeg";
    public static final String TIFF_FILTER = "tiff";
    public static final String FONT_FILTER = "font";
    public static final String METADATA_FILTER = "metadata";
    private List<PDFFilter> filters = new ArrayList<PDFFilter>();
    private boolean ignoreASCIIFilters = false;
    private boolean disableAllFilters = false;

    public PDFFilterList() {
    }

    public PDFFilterList(boolean ignoreASCIIFilters) {
        this.ignoreASCIIFilters = ignoreASCIIFilters;
    }

    public void setDisableAllFilters(boolean value2) {
        this.disableAllFilters = value2;
    }

    public boolean isDisableAllFilters() {
        return this.disableAllFilters;
    }

    public boolean isInitialized() {
        return this.filters.size() > 0;
    }

    public void addFilter(PDFFilter filter2) {
        if (filter2 != null) {
            if (this.ignoreASCIIFilters && filter2.isASCIIFilter()) {
                return;
            }
            this.filters.add(filter2);
        }
    }

    public void addFilter(String filterType) {
        if (filterType == null) {
            return;
        }
        if (filterType.equals("flate")) {
            this.addFilter(new FlateFilter());
        } else if (filterType.equals("null")) {
            this.addFilter(new NullFilter());
        } else if (filterType.equals("ascii-85")) {
            if (this.ignoreASCIIFilters) {
                return;
            }
            this.addFilter(new ASCII85Filter());
        } else if (filterType.equals("ascii-hex")) {
            if (this.ignoreASCIIFilters) {
                return;
            }
            this.addFilter(new ASCIIHexFilter());
        } else {
            if (filterType.equals("")) {
                return;
            }
            throw new IllegalArgumentException("Unsupported filter type in stream-filter-list: " + filterType);
        }
    }

    public void ensureFilterInPlace(PDFFilter pdfFilter) {
        if (this.filters.size() == 0) {
            this.addFilter(pdfFilter);
        } else if (!this.filters.get(0).equals(pdfFilter)) {
            this.filters.add(0, pdfFilter);
        }
    }

    public void addDefaultFilters(Map filters, String type) {
        if (METADATA_FILTER.equals(type)) {
            this.addFilter(new NullFilter());
            return;
        }
        List filterset = null;
        if (filters != null && (filterset = (List)filters.get(type)) == null) {
            filterset = (List)filters.get(DEFAULT_FILTER);
        }
        if (filterset == null || filterset.size() == 0) {
            if (JPEG_FILTER.equals(type)) {
                this.addFilter(new NullFilter());
            } else if (TIFF_FILTER.equals(type)) {
                this.addFilter(new NullFilter());
            } else if (PRECOMPRESSED_FILTER.equals(type)) {
                this.addFilter(new NullFilter());
            } else {
                this.addFilter(new FlateFilter());
            }
        } else {
            for (int i = 0; i < filterset.size(); ++i) {
                String v = (String)filterset.get(i);
                this.addFilter(v);
            }
        }
    }

    List<PDFFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    protected String buildFilterDictEntries() {
        if (this.filters.size() > 0) {
            ArrayList names = new ArrayList();
            ArrayList parms = new ArrayList();
            int nonNullParams = this.populateNamesAndParms(names, parms);
            return this.buildFilterEntries(names) + (nonNullParams > 0 ? this.buildDecodeParms(parms) : "");
        }
        return "";
    }

    protected void putFilterDictEntries(PDFDictionary dict) {
        if (this.filters.size() > 0) {
            ArrayList names = new ArrayList();
            ArrayList parms = new ArrayList();
            this.populateNamesAndParms(names, parms);
            this.putFilterEntries(dict, names);
            this.putDecodeParams(dict, parms);
        }
    }

    private int populateNamesAndParms(List names, List parms) {
        int nonNullParams = 0;
        for (int count2 = 0; count2 < this.filters.size(); ++count2) {
            PDFFilter filter2 = this.filters.get(count2);
            if (filter2.getName().length() <= 0) continue;
            names.add(0, filter2.getName());
            PDFObject param2 = filter2.getDecodeParms();
            if (param2 != null) {
                parms.add(0, param2);
                ++nonNullParams;
                continue;
            }
            parms.add(0, null);
        }
        return nonNullParams;
    }

    private String buildFilterEntries(List names) {
        int filterCount = 0;
        StringBuffer sb = new StringBuffer(64);
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            if (name.length() <= 0) continue;
            ++filterCount;
            sb.append(name);
            sb.append(" ");
        }
        if (filterCount > 0) {
            if (filterCount > 1) {
                return "/Filter [ " + sb.toString() + "]";
            }
            return "/Filter " + sb.toString();
        }
        return "";
    }

    private void putFilterEntries(PDFDictionary dict, List names) {
        PDFArray array = new PDFArray(dict);
        int c = names.size();
        for (int i = 0; i < c; ++i) {
            String name = (String)names.get(i);
            if (name.length() <= 0) continue;
            array.add(new PDFName(name));
        }
        if (array.length() > 0) {
            if (array.length() > 1) {
                dict.put("Filter", array);
            } else {
                dict.put("Filter", array.get(0));
            }
        }
    }

    private String buildDecodeParms(List parms) {
        StringBuffer sb = new StringBuffer();
        boolean needParmsEntry = false;
        sb.append("\n/DecodeParms ");
        if (parms.size() > 1) {
            sb.append("[ ");
        }
        for (int count2 = 0; count2 < parms.size(); ++count2) {
            String s2 = (String)parms.get(count2);
            if (s2 != null) {
                sb.append(s2);
                needParmsEntry = true;
            } else {
                sb.append("null");
            }
            sb.append(" ");
        }
        if (parms.size() > 1) {
            sb.append("]");
        }
        if (needParmsEntry) {
            return sb.toString();
        }
        return "";
    }

    private void putDecodeParams(PDFDictionary dict, List parms) {
        boolean needParmsEntry = false;
        PDFArray array = new PDFArray(dict);
        int c = parms.size();
        for (int i = 0; i < c; ++i) {
            Object obj = parms.get(i);
            if (obj != null) {
                array.add(obj);
                needParmsEntry = true;
                continue;
            }
            array.add(null);
        }
        if (array.length() > 0 & needParmsEntry) {
            if (array.length() > 1) {
                dict.put("DecodeParms", array);
            } else {
                dict.put("DecodeParms", array.get(0));
            }
        }
    }

    public OutputStream applyFilters(OutputStream stream) throws IOException {
        OutputStream out = stream;
        if (!this.isDisableAllFilters()) {
            for (int count2 = this.filters.size() - 1; count2 >= 0; --count2) {
                PDFFilter filter2 = this.filters.get(count2);
                out = filter2.applyFilter(out);
            }
        }
        return out;
    }
}

