/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.TemplateSubPatternAssociation;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.QName;
import org.apache.xpath.Expression;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;
import org.apache.xpath.patterns.UnionPattern;

public class TemplateList
implements Serializable {
    static boolean DEBUG = false;
    private Hashtable m_namedTemplates = new Hashtable(89);
    private Hashtable m_patternTable = new Hashtable(89);
    private TemplateSubPatternAssociation m_wildCardPatterns = null;
    private TemplateSubPatternAssociation m_textPatterns = null;
    private TemplateSubPatternAssociation m_docPatterns = null;
    private TemplateSubPatternAssociation m_commentPatterns = null;

    public void setTemplate(ElemTemplate template) {
        XPath matchXPath = template.getMatch();
        if (null == template.getName() && null == matchXPath) {
            template.error("ER_NEED_NAME_OR_MATCH_ATTRIB", new Object[]{"xsl:template"});
        }
        if (null != template.getName()) {
            ElemTemplate existingTemplate = (ElemTemplate)this.m_namedTemplates.get(template.getName());
            if (null == existingTemplate) {
                this.m_namedTemplates.put(template.getName(), template);
            } else {
                int existingPrecedence = existingTemplate.getStylesheetComposed().getImportCountComposed();
                int newPrecedence = template.getStylesheetComposed().getImportCountComposed();
                if (newPrecedence > existingPrecedence) {
                    this.m_namedTemplates.put(template.getName(), template);
                } else if (newPrecedence == existingPrecedence) {
                    template.error("ER_DUPLICATE_NAMED_TEMPLATE", new Object[]{template.getName()});
                }
            }
        }
        if (null != matchXPath) {
            Expression matchExpr = matchXPath.getExpression();
            if (matchExpr instanceof StepPattern) {
                this.insertPatternInTable((StepPattern)matchExpr, template);
            } else if (matchExpr instanceof UnionPattern) {
                UnionPattern upat = (UnionPattern)matchExpr;
                StepPattern[] pats = upat.getPatterns();
                int n = pats.length;
                int i = 0;
                while (i < n) {
                    this.insertPatternInTable(pats[i], template);
                    ++i;
                }
            }
        }
    }

    void dumpAssociationTables() {
        TemplateSubPatternAssociation head2;
        Enumeration associations = this.m_patternTable.elements();
        while (associations.hasMoreElements()) {
            head2 = (TemplateSubPatternAssociation)associations.nextElement();
            while (null != head2) {
                System.out.print("(" + head2.getTargetString() + ", " + head2.getPattern() + ")");
                head2 = head2.getNext();
            }
            System.out.println("\n.....");
        }
        head2 = this.m_wildCardPatterns;
        System.out.print("wild card list: ");
        while (null != head2) {
            System.out.print("(" + head2.getTargetString() + ", " + head2.getPattern() + ")");
            head2 = head2.getNext();
        }
        System.out.println("\n.....");
    }

    public void compose(StylesheetRoot sroot) {
        if (DEBUG) {
            System.out.println("Before wildcard insert...");
            this.dumpAssociationTables();
        }
        if (null != this.m_wildCardPatterns) {
            Enumeration associations = this.m_patternTable.elements();
            while (associations.hasMoreElements()) {
                TemplateSubPatternAssociation head2 = (TemplateSubPatternAssociation)associations.nextElement();
                TemplateSubPatternAssociation wild = this.m_wildCardPatterns;
                while (null != wild) {
                    try {
                        head2 = this.insertAssociationIntoList(head2, (TemplateSubPatternAssociation)wild.clone(), true);
                    }
                    catch (CloneNotSupportedException cnse) {
                        // empty catch block
                    }
                    wild = wild.getNext();
                }
            }
        }
        if (DEBUG) {
            System.out.println("After wildcard insert...");
            this.dumpAssociationTables();
        }
    }

    private TemplateSubPatternAssociation insertAssociationIntoList(TemplateSubPatternAssociation head2, TemplateSubPatternAssociation item, boolean isWildCardInsert) {
        boolean insertBefore;
        double workPriority;
        TemplateSubPatternAssociation next2;
        double priority = this.getPriorityOrScore(item);
        int importLevel = item.getImportLevel();
        int docOrder = item.getDocOrderPos();
        TemplateSubPatternAssociation insertPoint = head2;
        while (null != (next2 = insertPoint.getNext())) {
            workPriority = this.getPriorityOrScore(next2);
            if (importLevel > next2.getImportLevel()) break;
            if (importLevel < next2.getImportLevel()) {
                insertPoint = next2;
                continue;
            }
            if (priority > workPriority) break;
            if (priority < workPriority) {
                insertPoint = next2;
                continue;
            }
            if (docOrder >= next2.getDocOrderPos()) break;
            insertPoint = next2;
        }
        if (null == next2 || insertPoint == head2) {
            workPriority = this.getPriorityOrScore(insertPoint);
            insertBefore = importLevel > insertPoint.getImportLevel() ? true : (importLevel < insertPoint.getImportLevel() ? false : (priority > workPriority ? true : (priority < workPriority ? false : docOrder >= insertPoint.getDocOrderPos())));
        } else {
            insertBefore = false;
        }
        if (isWildCardInsert) {
            if (insertBefore) {
                item.setNext(insertPoint);
                String key = insertPoint.getTargetString();
                item.setTargetString(key);
                this.putHead(key, item);
                return item;
            }
            item.setNext(next2);
            insertPoint.setNext(item);
            return head2;
        }
        if (insertBefore) {
            item.setNext(insertPoint);
            if (insertPoint.isWild() || item.isWild()) {
                this.m_wildCardPatterns = item;
            } else {
                this.putHead(item.getTargetString(), item);
            }
            return item;
        }
        item.setNext(next2);
        insertPoint.setNext(item);
        return head2;
    }

    private void insertPatternInTable(StepPattern pattern, ElemTemplate template) {
        String target = pattern.getTargetString();
        if (null != target) {
            TemplateSubPatternAssociation head2;
            String pstring = template.getMatch().getPatternString();
            TemplateSubPatternAssociation association = new TemplateSubPatternAssociation(template, pattern, pstring);
            boolean isWildCard = association.isWild();
            TemplateSubPatternAssociation templateSubPatternAssociation = head2 = isWildCard ? this.m_wildCardPatterns : this.getHead(target);
            if (null == head2) {
                if (isWildCard) {
                    this.m_wildCardPatterns = association;
                } else {
                    this.putHead(target, association);
                }
            } else {
                this.insertAssociationIntoList(head2, association, false);
            }
        }
    }

    private double getPriorityOrScore(TemplateSubPatternAssociation matchPat) {
        StepPattern ex;
        double priority = matchPat.getTemplate().getPriority();
        if (priority == Double.NEGATIVE_INFINITY && (ex = matchPat.getStepPattern()) instanceof NodeTest) {
            return ((NodeTest)ex).getDefaultScore();
        }
        return priority;
    }

    public ElemTemplate getTemplate(QName qname) {
        return (ElemTemplate)this.m_namedTemplates.get(qname);
    }

    public TemplateSubPatternAssociation getHead(XPathContext xctxt, int targetNode, DTM dtm) {
        TemplateSubPatternAssociation head2;
        short targetNodeType = dtm.getNodeType(targetNode);
        switch (targetNodeType) {
            case 1: 
            case 2: {
                head2 = (TemplateSubPatternAssociation)this.m_patternTable.get(dtm.getLocalName(targetNode));
                break;
            }
            case 3: 
            case 4: {
                head2 = this.m_textPatterns;
                break;
            }
            case 5: 
            case 6: {
                head2 = (TemplateSubPatternAssociation)this.m_patternTable.get(dtm.getNodeName(targetNode));
                break;
            }
            case 7: {
                head2 = (TemplateSubPatternAssociation)this.m_patternTable.get(dtm.getLocalName(targetNode));
                break;
            }
            case 8: {
                head2 = this.m_commentPatterns;
                break;
            }
            case 9: 
            case 11: {
                head2 = this.m_docPatterns;
                break;
            }
            default: {
                head2 = (TemplateSubPatternAssociation)this.m_patternTable.get(dtm.getNodeName(targetNode));
            }
        }
        return null == head2 ? this.m_wildCardPatterns : head2;
    }

    public ElemTemplate getTemplateFast(XPathContext xctxt, int targetNode, int expTypeID, QName mode, int maxImportLevel, boolean quietConflictWarnings, DTM dtm) throws TransformerException {
        TemplateSubPatternAssociation head2;
        switch (dtm.getNodeType(targetNode)) {
            case 1: 
            case 2: {
                head2 = (TemplateSubPatternAssociation)this.m_patternTable.get(dtm.getLocalNameFromExpandedNameID(expTypeID));
                break;
            }
            case 3: 
            case 4: {
                head2 = this.m_textPatterns;
                break;
            }
            case 5: 
            case 6: {
                head2 = (TemplateSubPatternAssociation)this.m_patternTable.get(dtm.getNodeName(targetNode));
                break;
            }
            case 7: {
                head2 = (TemplateSubPatternAssociation)this.m_patternTable.get(dtm.getLocalName(targetNode));
                break;
            }
            case 8: {
                head2 = this.m_commentPatterns;
                break;
            }
            case 9: 
            case 11: {
                head2 = this.m_docPatterns;
                break;
            }
            default: {
                head2 = (TemplateSubPatternAssociation)this.m_patternTable.get(dtm.getNodeName(targetNode));
            }
        }
        if (null == head2 && null == (head2 = this.m_wildCardPatterns)) {
            return null;
        }
        xctxt.pushNamespaceContextNull();
        try {
            do {
                if (maxImportLevel > -1 && head2.getImportLevel() > maxImportLevel) continue;
                ElemTemplate template = head2.getTemplate();
                xctxt.setNamespaceContext(template);
                if (head2.m_stepPattern.execute(xctxt, targetNode, dtm, expTypeID) == NodeTest.SCORE_NONE || !head2.matchMode(mode)) continue;
                if (quietConflictWarnings) {
                    this.checkConflicts(head2, xctxt, targetNode, mode);
                }
                ElemTemplate elemTemplate = template;
                Object var12_11 = null;
                xctxt.popNamespaceContext();
                return elemTemplate;
            } while (null != (head2 = head2.getNext()));
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            xctxt.popNamespaceContext();
            throw throwable;
        }
        Object var12_12 = null;
        xctxt.popNamespaceContext();
        return null;
    }

    public ElemTemplate getTemplate(XPathContext xctxt, int targetNode, QName mode, boolean quietConflictWarnings, DTM dtm) throws TransformerException {
        TemplateSubPatternAssociation head2 = this.getHead(xctxt, targetNode, dtm);
        if (null != head2) {
            xctxt.pushNamespaceContextNull();
            xctxt.pushCurrentNodeAndExpression(targetNode, targetNode);
            try {
                do {
                    ElemTemplate template = head2.getTemplate();
                    xctxt.setNamespaceContext(template);
                    if (head2.m_stepPattern.execute(xctxt, targetNode) == NodeTest.SCORE_NONE || !head2.matchMode(mode)) continue;
                    if (quietConflictWarnings) {
                        this.checkConflicts(head2, xctxt, targetNode, mode);
                    }
                    ElemTemplate elemTemplate = template;
                    Object var10_9 = null;
                    xctxt.popCurrentNodeAndExpression();
                    xctxt.popNamespaceContext();
                    return elemTemplate;
                } while (null != (head2 = head2.getNext()));
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                xctxt.popCurrentNodeAndExpression();
                xctxt.popNamespaceContext();
                throw throwable;
            }
            Object var10_10 = null;
            xctxt.popCurrentNodeAndExpression();
            xctxt.popNamespaceContext();
            {
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ElemTemplate getTemplate(XPathContext xctxt, int targetNode, QName mode, int maxImportLevel, int endImportLevel, boolean quietConflictWarnings, DTM dtm) throws TransformerException {
        block6: {
            ElemTemplate elemTemplate;
            block5: {
                TemplateSubPatternAssociation head2 = this.getHead(xctxt, targetNode, dtm);
                if (null == head2) return null;
                xctxt.pushNamespaceContextNull();
                xctxt.pushCurrentNodeAndExpression(targetNode, targetNode);
                try {
                    do {
                        if (maxImportLevel > -1 && head2.getImportLevel() > maxImportLevel) continue;
                        if (head2.getImportLevel() <= maxImportLevel - endImportLevel) {
                            ElemTemplate elemTemplate2 = null;
                            Object var13_11 = null;
                            xctxt.popCurrentNodeAndExpression();
                            xctxt.popNamespaceContext();
                            return elemTemplate2;
                        }
                        ElemTemplate template = head2.getTemplate();
                        xctxt.setNamespaceContext(template);
                        if (head2.m_stepPattern.execute(xctxt, targetNode) == NodeTest.SCORE_NONE || !head2.matchMode(mode)) continue;
                        if (quietConflictWarnings) {
                            this.checkConflicts(head2, xctxt, targetNode, mode);
                        }
                        elemTemplate = template;
                        break block5;
                    } while (null != (head2 = head2.getNext()));
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    xctxt.popCurrentNodeAndExpression();
                    xctxt.popNamespaceContext();
                    throw throwable;
                }
            }
            Object var13_12 = null;
            xctxt.popCurrentNodeAndExpression();
            xctxt.popNamespaceContext();
            return elemTemplate;
        }
        Object var13_13 = null;
        xctxt.popCurrentNodeAndExpression();
        xctxt.popNamespaceContext();
        return null;
    }

    public TemplateWalker getWalker() {
        return new TemplateWalker();
    }

    private void checkConflicts(TemplateSubPatternAssociation head2, XPathContext xctxt, int targetNode, QName mode) {
    }

    private void addObjectIfNotFound(Object obj, Vector v) {
        int n = v.size();
        boolean addIt = true;
        int i = 0;
        while (i < n) {
            if (v.elementAt(i) == obj) {
                addIt = false;
                break;
            }
            ++i;
        }
        if (addIt) {
            v.addElement(obj);
        }
    }

    private Hashtable getNamedTemplates() {
        return this.m_namedTemplates;
    }

    private void setNamedTemplates(Hashtable v) {
        this.m_namedTemplates = v;
    }

    private TemplateSubPatternAssociation getHead(String key) {
        return (TemplateSubPatternAssociation)this.m_patternTable.get(key);
    }

    private void putHead(String key, TemplateSubPatternAssociation assoc) {
        if (key.equals("#text")) {
            this.m_textPatterns = assoc;
        } else if (key.equals("/")) {
            this.m_docPatterns = assoc;
        } else if (key.equals("#comment")) {
            this.m_commentPatterns = assoc;
        }
        this.m_patternTable.put(key, assoc);
    }

    public class TemplateWalker {
        private Enumeration hashIterator;
        private boolean inPatterns;
        private TemplateSubPatternAssociation curPattern;
        private Hashtable m_compilerCache = new Hashtable();

        private TemplateWalker() {
            this.hashIterator = TemplateList.this.m_patternTable.elements();
            this.inPatterns = true;
            this.curPattern = null;
        }

        public ElemTemplate next() {
            ElemTemplate ct;
            ElemTemplateElement retValue = null;
            do {
                if (this.inPatterns) {
                    if (null != this.curPattern) {
                        this.curPattern = this.curPattern.getNext();
                    }
                    if (null != this.curPattern) {
                        retValue = this.curPattern.getTemplate();
                    } else if (this.hashIterator.hasMoreElements()) {
                        this.curPattern = (TemplateSubPatternAssociation)this.hashIterator.nextElement();
                        retValue = this.curPattern.getTemplate();
                    } else {
                        this.inPatterns = false;
                        this.hashIterator = TemplateList.this.m_namedTemplates.elements();
                    }
                }
                if (this.inPatterns) continue;
                if (this.hashIterator.hasMoreElements()) {
                    retValue = (ElemTemplate)this.hashIterator.nextElement();
                    continue;
                }
                return null;
            } while (null != (ct = (ElemTemplate)this.m_compilerCache.get(new Integer(retValue.getUid()))));
            this.m_compilerCache.put(new Integer(retValue.getUid()), retValue);
            return retValue;
        }
    }
}

