/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Enumeration;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.NEW;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.Mode;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.Stylesheet;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.Template;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class ApplyImports
extends Instruction {
    private QName _modeName;
    private String _functionName;
    private int _precedence;

    ApplyImports() {
    }

    public void display(int indent) {
        this.indent(indent);
        Util.println("ApplyTemplates");
        this.indent(indent + 4);
        if (this._modeName != null) {
            this.indent(indent + 4);
            Util.println("mode " + this._modeName);
        }
    }

    public boolean hasWithParams() {
        return this.hasContents();
    }

    private int getMinPrecedence(int max2) {
        Stylesheet stylesheet = this.getStylesheet();
        Stylesheet root2 = this.getParser().getTopLevelStylesheet();
        int min2 = max2;
        Enumeration templates = root2.getContents().elements();
        while (templates.hasMoreElements()) {
            int prec;
            SyntaxTreeNode child = (SyntaxTreeNode)templates.nextElement();
            if (!(child instanceof Template)) continue;
            Stylesheet curr = child.getStylesheet();
            while (curr != null && curr != stylesheet) {
                curr = curr._importedFrom != null ? curr._importedFrom : (curr._includedFrom != null ? curr._includedFrom : null);
            }
            if (curr != stylesheet || (prec = child.getStylesheet().getImportPrecedence()) >= min2) continue;
            min2 = prec;
        }
        return min2;
    }

    public void parseContents(Parser parser) {
        Stylesheet stylesheet = this.getStylesheet();
        stylesheet.setTemplateInlining(false);
        Template template = this.getTemplate();
        this._modeName = template.getModeName();
        this._precedence = template.getImportPrecedence();
        stylesheet = parser.getTopLevelStylesheet();
        int maxPrecedence = this._precedence;
        int minPrecedence = this.getMinPrecedence(maxPrecedence);
        Mode mode = stylesheet.getMode(this._modeName);
        this._functionName = mode.functionName(minPrecedence, maxPrecedence);
        this.parseChildren(parser);
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        this.typeCheckContents(stable);
        return Type.Void;
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        Stylesheet stylesheet = classGen.getStylesheet();
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        int current = methodGen.getLocalIndex("current");
        il.append(classGen.loadTranslet());
        il.append(methodGen.loadDOM());
        int init2 = cpg.addMethodref("org.apache.xalan.xsltc.dom.SingletonIterator", "<init>", "(I)V");
        il.append(new NEW(cpg.addClass("org.apache.xalan.xsltc.dom.SingletonIterator")));
        il.append(InstructionConstants.DUP);
        il.append(methodGen.loadCurrentNode());
        il.append(new INVOKESPECIAL(init2));
        il.append(methodGen.loadHandler());
        String className = classGen.getStylesheet().getClassName();
        String signature = classGen.getApplyTemplatesSig();
        int applyTemplates = cpg.addMethodref(className, this._functionName, signature);
        il.append(new INVOKEVIRTUAL(applyTemplates));
    }
}

