/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.validate;

import java.util.ArrayList;
import org.gedcom4j.model.AbstractCitation;
import org.gedcom4j.model.LdsSpouseSealing;
import org.gedcom4j.validate.AbstractValidator;
import org.gedcom4j.validate.CitationValidator;
import org.gedcom4j.validate.GedcomValidator;

public class LdsSpouseSealingValidator
extends AbstractValidator {
    private LdsSpouseSealing s;

    public LdsSpouseSealingValidator(GedcomValidator rootValidator, LdsSpouseSealing s2) {
        this.rootValidator = rootValidator;
        this.s = s2;
    }

    protected void validate() {
        if (this.s == null) {
            this.addError("LDS Spouse Sealing is null and cannot be validated");
            return;
        }
        if (this.s.citations == null) {
            if (this.rootValidator.autorepair) {
                this.s.citations = new ArrayList();
                this.addInfo("citations collection for lds spouse sealing was null - rootValidator.autorepaired", this.s);
            } else {
                this.addError("citations collection for lds spouse sealing is null", this.s);
            }
        } else {
            for (AbstractCitation c : this.s.citations) {
                new CitationValidator(this.rootValidator, c).validate();
            }
        }
        this.checkCustomTags(this.s);
        this.checkOptionalString(this.s.date, "date", (Object)this.s);
        this.checkNotes(this.s.notes, this.s);
        this.checkOptionalString(this.s.place, "place", (Object)this.s);
        this.checkOptionalString(this.s.status, "status", (Object)this.s);
        this.checkOptionalString(this.s.temple, "temple", (Object)this.s);
    }
}

