/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.validate;

import java.util.ArrayList;
import org.gedcom4j.model.AbstractCitation;
import org.gedcom4j.model.FileReference;
import org.gedcom4j.model.Multimedia;
import org.gedcom4j.model.SupportedVersion;
import org.gedcom4j.model.UserReference;
import org.gedcom4j.validate.AbstractValidator;
import org.gedcom4j.validate.CitationValidator;
import org.gedcom4j.validate.GedcomValidationException;
import org.gedcom4j.validate.GedcomValidator;
import org.gedcom4j.validate.NotesValidator;

class MultimediaValidator
extends AbstractValidator {
    private final Multimedia mm;
    private SupportedVersion gedcomVersion;

    public MultimediaValidator(GedcomValidator rootValidator, Multimedia multimedia) {
        this.rootValidator = rootValidator;
        if (rootValidator == null) {
            throw new GedcomValidationException("Root validator passed in to MultimediaValidator constructor was null");
        }
        this.mm = multimedia;
        if (rootValidator.gedcom == null || rootValidator.gedcom.header == null || rootValidator.gedcom.header.gedcomVersion == null || rootValidator.gedcom.header.gedcomVersion.versionNumber == null) {
            if (rootValidator.autorepair) {
                this.gedcomVersion = SupportedVersion.V5_5_1;
                rootValidator.addInfo("Was not able to determine GEDCOM version - assuming 5.5.1", rootValidator.gedcom);
            } else {
                rootValidator.addError("Was not able to determine GEDCOM version - cannot validate multimedia objects", rootValidator.gedcom);
            }
        } else {
            this.gedcomVersion = rootValidator.gedcom.header.gedcomVersion.versionNumber;
        }
    }

    protected void validate() {
        this.validateCommon();
        if (this.v551()) {
            this.validate551();
        } else {
            this.validate55();
        }
    }

    private void checkFileReference(FileReference fr) {
        if (fr == null) {
            if (this.rootValidator.autorepair) {
                this.addError("Null file reference in list of file references in multimedia object - cannot repair", this.mm);
            } else {
                this.addError("Null file reference in list of file references in multimedia object", this.mm);
            }
            return;
        }
        this.checkRequiredString(fr.format, "format", (Object)fr);
        this.checkOptionalString(fr.mediaType, "media type", (Object)fr);
        this.checkOptionalString(fr.title, "title", (Object)fr);
        this.checkRequiredString(fr.referenceToFile, "reference to file", (Object)fr);
    }

    private void checkUserReferences() {
        if (this.mm.userReferences == null) {
            if (this.rootValidator.autorepair) {
                this.mm.userReferences = new ArrayList<UserReference>();
                this.rootValidator.addInfo("List of user references on multimedia object was null - repaired", this.mm);
            } else {
                this.rootValidator.addError("List of user references on multimedia object is null", this.mm);
                return;
            }
        }
        for (UserReference u : this.mm.userReferences) {
            this.checkCustomTags(u);
            if (u.referenceNum != null) continue;
            if (this.rootValidator.autorepair) {
                this.addError("User reference is has a null or blank reference number - cannot repair", u);
                continue;
            }
            this.addError("User reference is has a null or blank reference number", u);
        }
    }

    private void checkXref() {
        if (this.mm.xref == null || this.mm.xref.trim().length() == 0) {
            if (this.rootValidator.autorepair) {
                this.addError("Multimedia object must have xref - cannot autorepair", this.mm);
            } else {
                this.addError("Multimedia object must have xref", this.mm);
            }
            return;
        }
        if (this.rootValidator.gedcom.multimedia.get(this.mm.xref) != this.mm) {
            if (this.rootValidator.autorepair) {
                this.rootValidator.gedcom.multimedia.put(this.mm.xref, this.mm);
                this.rootValidator.addInfo("Multimedia object not keyed by xref in map - repaired", this.mm);
            } else {
                this.rootValidator.addError("Multimedia object not keyed by xref in map", this.mm);
            }
            return;
        }
    }

    private boolean v551() {
        return SupportedVersion.V5_5_1.equals((Object)this.gedcomVersion);
    }

    private void validate55() {
        if (this.mm.blob.isEmpty()) {
            if (this.rootValidator.autorepair) {
                this.addError("Embedded media object has an empty blob object - cannot repair", this.mm);
            } else {
                this.addError("Embedded media object has an empty blob object", this.mm);
            }
        }
        this.checkRequiredString(this.mm.embeddedMediaFormat, "embedded media format", (Object)this.mm);
        if (!this.mm.citations.isEmpty()) {
            if (this.rootValidator.autorepair) {
                this.mm.citations.clear();
                this.rootValidator.addInfo("Citations collection was populated, but not allowed in v5.5 of gedcom - repaired (cleared)", this.mm);
            } else {
                this.rootValidator.addError("Citations collection is populated, but not allowed in v5.5 of gedcom", this.mm);
            }
        }
    }

    private void validate551() {
        if (this.mm.fileReferences == null) {
            if (this.rootValidator.autorepair) {
                this.mm.fileReferences = new ArrayList<FileReference>();
                this.rootValidator.addInfo("Multimedia object did not have list of file references - repaired", this.mm);
            } else {
                this.rootValidator.addError("Multimedia object does not have list of file references", this.mm);
                return;
            }
        }
        for (FileReference fr : this.mm.fileReferences) {
            this.checkFileReference(fr);
        }
        if (this.mm.blob != null && !this.mm.blob.isEmpty()) {
            if (this.rootValidator.autorepair) {
                this.mm.blob.clear();
                this.addInfo("Embedded media object had a populated blob object, which is not allowed in GEDCOM 5.5.1 - repaired (cleared)", this.mm);
            } else {
                this.addError("Embedded media object has a populated blob object, which is not allowed in GEDCOM 5.5.1", this.mm);
            }
        }
        if (this.mm.embeddedMediaFormat != null) {
            if (this.rootValidator.autorepair) {
                this.mm.embeddedMediaFormat = null;
                this.rootValidator.addInfo("Multimedia object had a format for embedded media, which is not allowed in GEDCOM 5.5.1 - repaired (cleared)", this.mm);
            } else {
                this.rootValidator.addError("Multimedia object has a format for embedded media, which is not allowed in GEDCOM 5.5.1", this.mm);
            }
        }
        for (AbstractCitation c : this.mm.citations) {
            new CitationValidator(this.rootValidator, c).validate();
        }
    }

    private void validateCommon() {
        this.checkXref();
        this.checkOptionalString(this.mm.recIdNumber, "record id number", (Object)this.mm);
        this.checkChangeDate(this.mm.changeDate, this.mm);
        this.checkUserReferences();
        if (this.mm.citations == null) {
            if (this.rootValidator.autorepair) {
                this.mm.citations = new ArrayList<AbstractCitation>();
                this.addInfo("citations collection for multimedia object was null - rootValidator.autorepaired", this.mm);
            } else {
                this.addError("citations collection for multimedia object is null", this.mm);
            }
        }
        if (this.mm.continuedObject != null) {
            new MultimediaValidator(this.rootValidator, this.mm.continuedObject).validate();
        }
        if (this.mm.blob == null) {
            if (this.rootValidator.autorepair) {
                this.mm.blob = new ArrayList<String>();
                this.rootValidator.addInfo("Embedded blob was null - repaired", this.mm);
            } else {
                this.rootValidator.addError("Embedded blob is null", this.mm);
            }
        }
        new NotesValidator(this.rootValidator, this.mm, this.mm.notes).validate();
    }
}

