/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class ImporterTopLevel
extends IdScriptableObject {
    static final long serialVersionUID = -9095380847465315412L;
    private static final Object IMPORTER_TAG = new Object();
    private static final int Id_constructor = 1;
    private static final int Id_importClass = 2;
    private static final int Id_importPackage = 3;
    private static final int MAX_PROTOTYPE_ID = 3;
    private ObjArray importedPackages = new ObjArray();
    private boolean topScopeFlag;

    public ImporterTopLevel() {
    }

    public ImporterTopLevel(Context context) {
        this(context, false);
    }

    public ImporterTopLevel(Context context, boolean bl) {
        this.initStandardObjects(context, bl);
    }

    public String getClassName() {
        return this.topScopeFlag ? "global" : "JavaImporter";
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        ImporterTopLevel importerTopLevel = new ImporterTopLevel();
        importerTopLevel.exportAsJSClass(3, scriptable, bl);
    }

    public void initStandardObjects(Context context, boolean bl) {
        context.initStandardObjects(this, bl);
        this.topScopeFlag = true;
        IdFunctionObject idFunctionObject = this.exportAsJSClass(3, this, false);
        if (bl) {
            idFunctionObject.sealObject();
        }
        this.delete("constructor");
    }

    public boolean has(String string2, Scriptable scriptable) {
        return super.has(string2, scriptable) || this.getPackageProperty(string2, scriptable) != NOT_FOUND;
    }

    public Object get(String string2, Scriptable scriptable) {
        Object object = super.get(string2, scriptable);
        if (object != NOT_FOUND) {
            return object;
        }
        object = this.getPackageProperty(string2, scriptable);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getPackageProperty(String string2, Scriptable scriptable) {
        Object[] objectArray;
        Object object = NOT_FOUND;
        ObjArray objArray = this.importedPackages;
        synchronized (objArray) {
            objectArray = this.importedPackages.toArray();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            NativeJavaPackage nativeJavaPackage = (NativeJavaPackage)objectArray[i];
            Object object2 = nativeJavaPackage.getPkgProperty(string2, scriptable, false);
            if (object2 == null || object2 instanceof NativeJavaPackage) continue;
            if (object == NOT_FOUND) {
                object = object2;
                continue;
            }
            throw Context.reportRuntimeError2("msg.ambig.import", object.toString(), object2.toString());
        }
        return object;
    }

    public void importPackage(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        this.js_importPackage(objectArray);
    }

    private Object js_construct(Scriptable scriptable, Object[] objectArray) {
        ImporterTopLevel importerTopLevel = new ImporterTopLevel();
        for (int i = 0; i != objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof NativeJavaClass) {
                importerTopLevel.importClass((NativeJavaClass)object);
                continue;
            }
            if (object instanceof NativeJavaPackage) {
                importerTopLevel.importPackage((NativeJavaPackage)object);
                continue;
            }
            throw Context.reportRuntimeError1("msg.not.class.not.pkg", Context.toString(object));
        }
        importerTopLevel.setParentScope(scriptable);
        importerTopLevel.setPrototype(this);
        return importerTopLevel;
    }

    private Object js_importClass(Object[] objectArray) {
        for (int i = 0; i != objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof NativeJavaClass)) {
                throw Context.reportRuntimeError1("msg.not.class", Context.toString(object));
            }
            this.importClass((NativeJavaClass)object);
        }
        return Undefined.instance;
    }

    private Object js_importPackage(Object[] objectArray) {
        for (int i = 0; i != objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof NativeJavaPackage)) {
                throw Context.reportRuntimeError1("msg.not.pkg", Context.toString(object));
            }
            this.importPackage((NativeJavaPackage)object);
        }
        return Undefined.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importPackage(NativeJavaPackage nativeJavaPackage) {
        if (nativeJavaPackage == null) {
            return;
        }
        ObjArray objArray = this.importedPackages;
        synchronized (objArray) {
            for (int i = 0; i != this.importedPackages.size(); ++i) {
                if (!nativeJavaPackage.equals(this.importedPackages.get(i))) continue;
                return;
            }
            this.importedPackages.add(nativeJavaPackage);
        }
    }

    private void importClass(NativeJavaClass nativeJavaClass) {
        String string2 = nativeJavaClass.getClassObject().getName();
        String string3 = string2.substring(string2.lastIndexOf(46) + 1);
        Object object = this.get(string3, (Scriptable)this);
        if (object != NOT_FOUND && object != nativeJavaClass) {
            throw Context.reportRuntimeError1("msg.prop.defined", string3);
        }
        this.put(string3, (Scriptable)this, (Object)nativeJavaClass);
    }

    protected void initPrototypeId(int n) {
        String string2;
        int n2;
        switch (n) {
            case 1: {
                n2 = 0;
                string2 = "constructor";
                break;
            }
            case 2: {
                n2 = 1;
                string2 = "importClass";
                break;
            }
            case 3: {
                n2 = 1;
                string2 = "importPackage";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(IMPORTER_TAG, n, string2, n2);
    }

    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(IMPORTER_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return this.js_construct(scriptable, objectArray);
            }
            case 2: {
                return this.realThis(scriptable2, idFunctionObject).js_importClass(objectArray);
            }
            case 3: {
                return this.realThis(scriptable2, idFunctionObject).js_importPackage(objectArray);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private ImporterTopLevel realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (this.topScopeFlag) {
            return this;
        }
        if (!(scriptable instanceof ImporterTopLevel)) {
            throw ImporterTopLevel.incompatibleCallError(idFunctionObject);
        }
        return (ImporterTopLevel)scriptable;
    }

    protected int findPrototypeId(String string2) {
        int n = 0;
        String string3 = null;
        int n2 = string2.length();
        if (n2 == 11) {
            char c = string2.charAt(0);
            if (c == 'c') {
                string3 = "constructor";
                n = 1;
            } else if (c == 'i') {
                string3 = "importClass";
                n = 2;
            }
        } else if (n2 == 13) {
            string3 = "importPackage";
            n = 3;
        }
        if (string3 != null && string3 != string2 && !string3.equals(string2)) {
            n = 0;
        }
        return n;
    }
}

