/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

final class NativeBoolean
extends IdScriptableObject {
    static final long serialVersionUID = -3716996899943880933L;
    private static final Object BOOLEAN_TAG = new Object();
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int Id_valueOf = 4;
    private static final int MAX_PROTOTYPE_ID = 4;
    private boolean booleanValue;

    static void init(Scriptable scriptable, boolean bl) {
        NativeBoolean nativeBoolean = new NativeBoolean(false);
        nativeBoolean.exportAsJSClass(4, scriptable, bl);
    }

    private NativeBoolean(boolean bl) {
        this.booleanValue = bl;
    }

    public String getClassName() {
        return "Boolean";
    }

    public Object getDefaultValue(Class clazz) {
        if (clazz == ScriptRuntime.BooleanClass) {
            return ScriptRuntime.wrapBoolean(this.booleanValue);
        }
        return super.getDefaultValue(clazz);
    }

    protected void initPrototypeId(int n) {
        String string2;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string2 = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string2 = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string2 = "toSource";
                break;
            }
            case 4: {
                n2 = 0;
                string2 = "valueOf";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(BOOLEAN_TAG, n, string2, n2);
    }

    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(BOOLEAN_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        if (n == 1) {
            boolean bl = ScriptRuntime.toBoolean(objectArray, 0);
            if (scriptable2 == null) {
                return new NativeBoolean(bl);
            }
            return ScriptRuntime.wrapBoolean(bl);
        }
        if (!(scriptable2 instanceof NativeBoolean)) {
            throw NativeBoolean.incompatibleCallError(idFunctionObject);
        }
        boolean bl = ((NativeBoolean)scriptable2).booleanValue;
        switch (n) {
            case 2: {
                return bl ? "true" : "false";
            }
            case 3: {
                return bl ? "(new Boolean(true))" : "(new Boolean(false))";
            }
            case 4: {
                return ScriptRuntime.wrapBoolean(bl);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    protected int findPrototypeId(String string2) {
        int n = 0;
        String string3 = null;
        int n2 = string2.length();
        if (n2 == 7) {
            string3 = "valueOf";
            n = 4;
        } else if (n2 == 8) {
            char c = string2.charAt(3);
            if (c == 'o') {
                string3 = "toSource";
                n = 3;
            } else if (c == 't') {
                string3 = "toString";
                n = 2;
            }
        } else if (n2 == 11) {
            string3 = "constructor";
            n = 1;
        }
        if (string3 != null && string3 != string2 && !string3.equals(string2)) {
            n = 0;
        }
        return n;
    }
}

