/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

public class NativeJavaClass
extends NativeJavaObject
implements Function {
    static final long serialVersionUID = -6460763940409461664L;
    private Hashtable staticFieldAndMethods;

    public NativeJavaClass() {
    }

    public NativeJavaClass(Scriptable scriptable, Class clazz) {
        this.parent = scriptable;
        this.javaObject = clazz;
        this.initMembers();
    }

    protected void initMembers() {
        Class clazz = (Class)this.javaObject;
        this.members = JavaMembers.lookupClass(this.parent, clazz, clazz);
        this.staticFieldAndMethods = this.members.getFieldAndMethodsObjects(this, clazz, true);
    }

    public String getClassName() {
        return "JavaClass";
    }

    public boolean has(String string2, Scriptable scriptable) {
        return this.members.has(string2, true);
    }

    public Object get(String string2, Scriptable scriptable) {
        if (string2.equals("prototype")) {
            return null;
        }
        Object object = Scriptable.NOT_FOUND;
        if (this.staticFieldAndMethods != null && (object = this.staticFieldAndMethods.get(string2)) != null) {
            return object;
        }
        if (this.members.has(string2, true)) {
            object = this.members.get(this, string2, this.javaObject, true);
        } else {
            Class clazz = NativeJavaClass.findNestedClass(this.getClassObject(), string2);
            if (clazz == null) {
                throw this.members.reportMemberNotFound(string2);
            }
            NativeJavaClass nativeJavaClass = new NativeJavaClass(ScriptableObject.getTopLevelScope(this), clazz);
            nativeJavaClass.setParentScope(this);
            object = nativeJavaClass;
        }
        return object;
    }

    public void put(String string2, Scriptable scriptable, Object object) {
        this.members.put(this, string2, this.javaObject, object, true);
    }

    public Object[] getIds() {
        return this.members.getIds(true);
    }

    public Class getClassObject() {
        return (Class)super.unwrap();
    }

    public Object getDefaultValue(Class clazz) {
        if (clazz == null || clazz == ScriptRuntime.StringClass) {
            return this.toString();
        }
        if (clazz == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (clazz == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (objectArray.length == 1 && objectArray[0] instanceof Scriptable) {
            Class clazz = this.getClassObject();
            Scriptable scriptable3 = (Scriptable)objectArray[0];
            do {
                Object object;
                if (!(scriptable3 instanceof Wrapper) || !clazz.isInstance(object = ((Wrapper)((Object)scriptable3)).unwrap())) continue;
                return scriptable3;
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
        }
        return this.construct(context, scriptable, objectArray);
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        String string2;
        Class clazz;
        block5: {
            clazz = this.getClassObject();
            int n = clazz.getModifiers();
            if (!Modifier.isInterface(n) && !Modifier.isAbstract(n)) {
                MemberBox[] memberBoxArray = this.members.ctors;
                int n2 = NativeJavaMethod.findFunction(context, memberBoxArray, objectArray);
                if (n2 < 0) {
                    String string3 = NativeJavaMethod.scriptSignature(objectArray);
                    throw Context.reportRuntimeError2("msg.no.java.ctor", clazz.getName(), string3);
                }
                return NativeJavaClass.constructSpecific(context, scriptable, objectArray, memberBoxArray[n2]);
            }
            Scriptable scriptable2 = ScriptableObject.getTopLevelScope(this);
            string2 = "";
            try {
                Object object = scriptable2.get("JavaAdapter", scriptable2);
                if (object != NOT_FOUND) {
                    Function function = (Function)object;
                    Object[] objectArray2 = new Object[]{this, objectArray[0]};
                    return function.construct(context, scriptable2, objectArray2);
                }
            }
            catch (Exception exception) {
                String string4 = exception.getMessage();
                if (string4 == null) break block5;
                string2 = string4;
            }
        }
        throw Context.reportRuntimeError2("msg.cant.instantiate", string2, clazz.getName());
    }

    static Scriptable constructSpecific(Context context, Scriptable scriptable, Object[] objectArray, MemberBox memberBox) {
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        Class[] classArray = memberBox.argTypes;
        Object[] objectArray2 = objectArray;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            Object object2 = Context.jsToJava(object, classArray[i]);
            if (object2 == object) continue;
            if (objectArray == objectArray2) {
                objectArray = (Object[])objectArray2.clone();
            }
            objectArray[i] = object2;
        }
        Object object = memberBox.newInstance(objectArray);
        return context.getWrapFactory().wrapNewObject(context, scriptable2, object);
    }

    public String toString() {
        return "[JavaClass " + this.getClassObject().getName() + "]";
    }

    public boolean hasInstance(Scriptable scriptable) {
        if (scriptable instanceof Wrapper && !(scriptable instanceof NativeJavaClass)) {
            Object object = ((Wrapper)((Object)scriptable)).unwrap();
            return this.getClassObject().isInstance(object);
        }
        return false;
    }

    private static Class findNestedClass(Class clazz, String string2) {
        String string3 = clazz.getName() + '$' + string2;
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            return Kit.classOrNull(string3);
        }
        return Kit.classOrNull(classLoader, string3);
    }
}

