/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.reverse.utils;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class ReverseEngineeringUtils {
    private static final HashMap<String, Class<?>> WRAPPER_TYPES_MAP = ReverseEngineeringUtils.getWrapperTypesMap();

    public static String normalizeToJSONProperty(String attributeName) {
        if (attributeName != null) {
            int charAt;
            int n = ((String)attributeName).length() >= 2 ? 2 : (charAt = ((String)attributeName).length() >= 1 ? 1 : -1);
            if (charAt > 0) {
                attributeName = ((String)attributeName).substring(0, charAt).toLowerCase() + ((String)attributeName).substring(charAt, ((String)attributeName).length());
            }
        }
        return attributeName;
    }

    public static String splitCamelCase(String s) {
        Object result = s.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
        String[] parts = ((String)result).split("_");
        result = "";
        for (String p : parts) {
            result = (String)result + StringUtils.capitalize((String)p);
        }
        return result;
    }

    private static HashMap<String, Class<?>> getWrapperTypesMap() {
        HashMap builtInMap = new HashMap();
        builtInMap.put("int", Integer.class);
        builtInMap.put("long", Long.class);
        builtInMap.put("double", Double.class);
        builtInMap.put("float", Float.class);
        builtInMap.put("bool", Boolean.class);
        builtInMap.put("boolean", Boolean.class);
        builtInMap.put("char", Character.class);
        builtInMap.put("byte", Byte.class);
        builtInMap.put("void", Void.class);
        builtInMap.put("short", Short.class);
        return builtInMap;
    }

    public static String unquote(String str) {
        if (str != null && str.length() >= 2 && (str.startsWith("\"") || str.startsWith("'")) && (str.endsWith("\"") || str.endsWith("'"))) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static String getWrapperType(String type) {
        Class<?> wrapper = WRAPPER_TYPES_MAP.get(type);
        if (wrapper != null) {
            return wrapper.getCanonicalName();
        }
        return type;
    }
}

