/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.model.factories.resource.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.brijframework.Access;
import org.brijframework.model.config.asm.ModelConfigration;
import org.brijframework.model.factories.resource.asm.AbstractTypeModelResourceFactory;
import org.brijframework.model.resource.ConstructorModelResource;
import org.brijframework.model.resource.ParameterModelResource;
import org.brijframework.model.resource.PropertyModelResource;
import org.brijframework.model.resource.TypeModelResource;
import org.brijframework.model.resource.impl.ConstructorModelResourceImpl;
import org.brijframework.model.resource.impl.ParameterModelResourceImpl;
import org.brijframework.model.resource.impl.PropertyModelResourceImpl;
import org.brijframework.model.resource.impl.RelationPropertyModelResourceImpl;
import org.brijframework.model.resource.impl.TypeModelResourceImpl;
import org.brijframework.resources.factory.json.JsonResourceFactory;
import org.brijframework.resources.files.json.JsonResource;
import org.brijframework.support.factories.SingletonFactory;
import org.brijframework.support.ordering.OrderOn;
import org.brijframework.util.accessor.PropertyAccessorUtil;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.factories.ReflectionFactory;
import org.brijframework.util.printer.LoggerConsole;
import org.brijframework.util.reflect.ClassUtil;
import org.brijframework.util.reflect.FieldUtil;
import org.brijframework.util.reflect.InstanceUtil;
import org.brijframework.util.support.ReflectionAccess;
import org.brijframework.util.text.StringUtil;
import org.json.JSONException;

@OrderOn(value=2)
public class JsonTypeModelResourceFactory
extends AbstractTypeModelResourceFactory<String, TypeModelResource> {
    private static JsonTypeModelResourceFactory factory;

    @SingletonFactory
    public static JsonTypeModelResourceFactory getFactory() {
        if (factory == null) {
            factory = new JsonTypeModelResourceFactory();
        }
        return factory;
    }

    public List<ModelConfigration> configration() {
        Object resources = this.getEnvProperty("application.model.config");
        if (resources == null) {
            LoggerConsole.screen((String)"ModelConfigration", (String)"Model configration not found :application.model.config");
            return null;
        }
        LoggerConsole.screen((String)"ModelConfigration", (String)("Model configration found :application.model.config | " + resources));
        if (resources instanceof List) {
            return this.build((List)resources);
        }
        if (resources instanceof Map) {
            return this.build((Map)resources);
        }
        LoggerConsole.screen((String)"ModelConfigration", (String)("Invalid model configration : " + resources));
        return null;
    }

    private List<ModelConfigration> build(Map<String, Object> resource) {
        ArrayList<ModelConfigration> configs = new ArrayList<ModelConfigration>();
        configs.add((ModelConfigration)InstanceUtil.getInstance(ModelConfigration.class, resource));
        return configs;
    }

    private List<ModelConfigration> build(List<Map<String, Object>> resources) {
        ArrayList<ModelConfigration> configs = new ArrayList<ModelConfigration>();
        for (Map<String, Object> resource : resources) {
            configs.add((ModelConfigration)InstanceUtil.getInstance(ModelConfigration.class, resource));
        }
        return configs;
    }

    public JsonTypeModelResourceFactory loadFactory() {
        List<ModelConfigration> configs = this.configration();
        if (configs == null) {
            LoggerConsole.screen((String)"ModelConfigration", (String)("Invalid model configration : " + configs));
            return this;
        }
        for (ModelConfigration modelConfig : configs) {
            if (!modelConfig.isEnable()) {
                LoggerConsole.screen((String)"ModelConfigration", (String)("Model configration disabled found :" + modelConfig.getLocation()));
                continue;
            }
            Collection resources = JsonResourceFactory.factory().getResources((Object)modelConfig.getLocation());
            for (JsonResource resource : resources) {
                if (resource.isJsonList()) {
                    try {
                        this.register(resource.toObjectList());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                if (!resource.isJsonObject()) continue;
                try {
                    this.register(resource.toObjectMap());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return this;
    }

    @Override
    public void register(List<Object> resources) {
        Assertion.notNull(resources, (String)"Invalid resources");
        for (Object object : resources) {
            if (!(object instanceof Map)) continue;
            this.register((Map)object);
        }
    }

    @Override
    public void register(Map<String, Object> resourceMap) {
        TypeModelResourceImpl typeModelResource = (TypeModelResourceImpl)InstanceUtil.getInstance(TypeModelResourceImpl.class, (Object[])new Object[0]);
        String id = (String)resourceMap.remove("id");
        Assertion.notEmpty((Object)id, (String)"Invalid id for TypeModelResource");
        typeModelResource.setId(id);
        String type = (String)resourceMap.remove("type");
        Assertion.notEmpty((Object)type, (String)"Invalid type for TypeModelResource");
        typeModelResource.setType(type);
        Class typeClass = ClassUtil.getClass((String)type);
        Assertion.notEmpty((Object)typeClass, (String)"Not found type for TypeModelResource");
        String name = (String)resourceMap.remove("name");
        if (StringUtil.isEmpty((String)name)) {
            name = typeClass.getSimpleName();
        }
        typeModelResource.setName(name);
        String access = (String)resourceMap.get("access");
        if (StringUtil.isEmpty((String)access)) {
            access = ReflectionAccess.PUBLIC.toString();
        }
        typeModelResource.setAccess(access);
        Object constructor = resourceMap.get("constructor");
        if (constructor instanceof Map) {
            typeModelResource.setConstructor(this.createConstructor(typeModelResource, (Map)resourceMap.get("constructor")));
        } else {
            typeModelResource.setConstructor(this.createConstructor(typeModelResource, null));
        }
        Map fieldMap = FieldUtil.getAllFieldMap((Class)typeClass, (ReflectionAccess)ReflectionAccess.PRIVATE);
        Map properties = (Map)resourceMap.remove("properties");
        if (properties != null) {
            properties.forEach((key, value) -> {
                Field field = (Field)fieldMap.get(key);
                Assertion.notEmpty((Object)field, (String)("Property not found for " + type + " of " + id));
                if (!ReflectionFactory.getFactory().isProjectClass(field.getType())) {
                    typeModelResource.getProperties().put((String)key, (PropertyModelResource)InstanceUtil.getInstance(PropertyModelResourceImpl.class, (Map)value));
                } else {
                    typeModelResource.getProperties().put((String)key, (PropertyModelResource)InstanceUtil.getInstance(RelationPropertyModelResourceImpl.class, (Map)value));
                }
            });
        }
        PropertyAccessorUtil.setProperties((Object)typeModelResource, resourceMap, (ReflectionAccess)ReflectionAccess.PRIVATE);
        this.register(typeModelResource.getId(), typeModelResource);
    }

    private ConstructorModelResource<?> createConstructor(TypeModelResource typeModelResource, Map<String, Object> constructor) {
        ConstructorModelResourceImpl constructorModelResource = new ConstructorModelResourceImpl();
        if (constructor != null) {
            String access = (String)constructor.get("access");
            constructorModelResource.setAccess(access);
            String id = (String)constructor.get("id");
            constructorModelResource.setId(StringUtil.isEmpty((String)id) || "DEFAULT".equalsIgnoreCase(id) ? typeModelResource.getId() : id);
            String name = (String)constructor.get("name");
            constructorModelResource.setName(StringUtil.isEmpty((String)name) || "DEFAULT".equalsIgnoreCase(name) ? typeModelResource.getName() : name);
            List parameters = (List)constructor.get("parameters");
            if (parameters != null) {
                for (Map modelParam : parameters) {
                    constructorModelResource.getParameterList().add(this.getModelParam(modelParam));
                }
            }
        }
        return constructorModelResource;
    }

    private ParameterModelResource getModelParam(Map<String, Object> modelParam) {
        ParameterModelResourceImpl parameterModelResource = new ParameterModelResourceImpl();
        parameterModelResource.setId((String)modelParam.get("name"));
        Integer index = null;
        try {
            index = Integer.valueOf(String.valueOf(modelParam.get("index")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Assertion.notNull(index, (String)"Parameter index is required.");
        parameterModelResource.setIndex(index);
        String type = (String)modelParam.get("type");
        Assertion.notNull((Object)type, (String)"Parameter type is required.");
        parameterModelResource.setType(type);
        parameterModelResource.setAccess(Access.AUTO.toString());
        return parameterModelResource;
    }
}

