/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.model.mapper.factories.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.brijframework.factories.impl.module.AbstractModuleFactory;
import org.brijframework.model.config.ModelConfig;
import org.brijframework.model.config.asm.ModelConfigration;
import org.brijframework.model.mapper.factories.ModelMapperFactory;
import org.brijframework.model.mapper.model.PropertyModelMapperResource;
import org.brijframework.model.mapper.model.TypeModelMapperResource;
import org.brijframework.resources.factory.json.JsonResourceFactory;
import org.brijframework.resources.files.json.JsonResource;
import org.brijframework.support.factories.SingletonFactory;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.reflect.FieldUtil;
import org.brijframework.util.reflect.InstanceUtil;
import org.brijframework.util.support.ReflectionAccess;
import org.json.JSONException;

public class JsonTypeModelMapperResourceFactory
extends AbstractModuleFactory<String, TypeModelMapperResource>
implements ModelMapperFactory<String, TypeModelMapperResource> {
    protected static JsonTypeModelMapperResourceFactory factory;

    protected JsonTypeModelMapperResourceFactory() {
    }

    @SingletonFactory
    public static JsonTypeModelMapperResourceFactory getFactory() {
        if (factory == null) {
            factory = new JsonTypeModelMapperResourceFactory();
        }
        return factory;
    }

    public List<ModelConfig> configration() {
        Object resources = this.getContainer().getContext().getEnvironment().get("application.model.config.mapper");
        if (resources == null) {
            System.err.println("Mapper configration not found :application.model.config.mapper");
            return null;
        }
        System.err.println("Mapper configration found :application.model.config.mapper");
        if (resources instanceof List) {
            return this.build((List)resources);
        }
        if (resources instanceof Map) {
            return this.build((Map)resources);
        }
        System.err.println("Invalid mapper configration : " + resources);
        return null;
    }

    private List<ModelConfig> build(Map<String, Object> resource) {
        ArrayList<ModelConfig> configs = new ArrayList<ModelConfig>();
        configs.add((ModelConfig)InstanceUtil.getInstance(ModelConfigration.class, resource));
        return configs;
    }

    private List<ModelConfig> build(List<Map<String, Object>> resources) {
        ArrayList<ModelConfig> configs = new ArrayList<ModelConfig>();
        for (Map<String, Object> resource : resources) {
            configs.add((ModelConfig)InstanceUtil.getInstance(ModelConfigration.class, resource));
        }
        return configs;
    }

    public JsonTypeModelMapperResourceFactory loadFactory() {
        List<ModelConfig> configs = this.configration();
        if (configs == null) {
            System.err.println("Invalid mapper configration : " + configs);
            return this;
        }
        for (ModelConfig modelConfig : configs) {
            if (!modelConfig.isEnable()) {
                System.err.println("mapper configration disabled found :" + modelConfig.getLocation());
            }
            Collection resources = JsonResourceFactory.factory().getResources((Object)modelConfig.getLocation());
            for (JsonResource resource : resources) {
                if (resource.isJsonList()) {
                    try {
                        this.register(resource.toObjectList());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                if (!resource.isJsonObject()) continue;
                try {
                    this.register(resource.toObjectMap());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return this;
    }

    public void register(List<Object> resources) {
        Assertion.notNull(resources, (String)"Invalid resources");
        for (Object object : resources) {
            if (!(object instanceof Map)) continue;
            this.register((Map)object);
        }
    }

    public void register(Map<String, Object> resourceMap) {
        Assertion.notNull(resourceMap, (String)("Invalid target :" + resourceMap));
        Map properties = (Map)resourceMap.remove("properties");
        TypeModelMapperResource metaSetup = (TypeModelMapperResource)InstanceUtil.getInstance(TypeModelMapperResource.class, resourceMap);
        if (properties != null) {
            properties.forEach((key, property) -> {
                PropertyModelMapperResource pptMapperModel = this.getPropertyMapper((Class<?>)metaSetup.getType(), (String)key, (Map<String, Object>)property);
                pptMapperModel.setId((String)key);
                String destinationKey = metaSetup.getName() + "_" + pptMapperModel.getDestination();
                String sourceKey = metaSetup.getName() + "_" + pptMapperModel.getSource();
                String idKey = metaSetup.getName() + "_" + pptMapperModel.getId();
                System.err.println("PptMapperModel    :" + idKey);
                metaSetup.getProperties().put(idKey, pptMapperModel);
                if (pptMapperModel.getSource() != null && !metaSetup.getProperties().containsKey(sourceKey)) {
                    System.err.println("PptMapperModel    :" + metaSetup.getName() + "_" + pptMapperModel.getSource());
                    metaSetup.getProperties().put(metaSetup.getName() + "_" + pptMapperModel.getSource(), pptMapperModel);
                }
                if (pptMapperModel.getDestination() != null && !metaSetup.getProperties().containsKey(destinationKey)) {
                    System.err.println("PptMapperModel    :" + destinationKey);
                    metaSetup.getProperties().put(metaSetup.getName() + "_" + pptMapperModel.getDestination(), pptMapperModel);
                }
            });
        }
        this.register(metaSetup.getId(), metaSetup);
    }

    private PropertyModelMapperResource getPropertyMapper(Class<?> type, String _field, Map<String, Object> property) {
        PropertyModelMapperResource pptMapperModel = (PropertyModelMapperResource)InstanceUtil.getInstance(PropertyModelMapperResource.class, property);
        if (type != null) {
            pptMapperModel.setTarget(FieldUtil.getField(type, (String)_field, (ReflectionAccess)ReflectionAccess.PRIVATE));
        }
        return pptMapperModel;
    }

    protected void preregister(String key, TypeModelMapperResource value) {
    }

    protected void postregister(String key, TypeModelMapperResource value) {
    }
}

