/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.factories;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.brijframework.util.factories.ClassFileResourceUtil;
import org.brijframework.util.factories.JarFileResourceUtil;

public final class ReflectionFactory {
    private static final String INTERNAL_CLASS = "INTERNAL_CLASS";
    private static final String EXTERNAL_CLASS = "EXTERNAL_CLASS";
    private ConcurrentHashMap<String, Set<Class<?>>> cache = new ConcurrentHashMap();
    private static ReflectionFactory factory;

    public ReflectionFactory() {
        this.getCache().put(INTERNAL_CLASS, new HashSet());
        this.getCache().put(EXTERNAL_CLASS, new HashSet());
    }

    public static ReflectionFactory getFactory() {
        if (factory == null) {
            factory = new ReflectionFactory();
            factory.loadFactory();
        }
        return factory;
    }

    private void loadFactory() {
        try {
            ClassFileResourceUtil.getClassList().forEach(cls -> this.getCache().get(INTERNAL_CLASS).add((Class<?>)cls));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            JarFileResourceUtil.getClassList().forEach(cls -> this.getCache().get(EXTERNAL_CLASS).add((Class<?>)cls));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ConcurrentHashMap<String, Set<Class<?>>> getCache() {
        return this.cache;
    }

    public Set<Class<?>> getInternalClassList() {
        return this.getCache().get(INTERNAL_CLASS);
    }

    public Set<Class<?>> getExternalClassList() {
        return this.getCache().get(EXTERNAL_CLASS);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(ReflectionFactory.getFactory().getExternalClassList());
    }

    public boolean isProjectClass(Class<? extends Object> cls) {
        return this.getInternalClassList().contains(cls);
    }

    public boolean isJarClass(Class<? extends Object> cls) {
        return this.getExternalClassList().contains(cls);
    }
}

