/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.location;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Base64;

public class ZipUtil {
    private static File currentDir = null;
    private static final int BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesAftrZippingFolder(File inFolder) {
        if (inFolder == null || !inFolder.exists()) {
            System.out.println("Please specify the correct FOLDER path for zip");
            return null;
        }
        String rootFolderName = inFolder.getName();
        int BUFFER = 2048;
        BufferedInputStream in = null;
        ZipOutputStream out = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            out = new ZipOutputStream(new BufferedOutputStream(baos));
            byte[] data = new byte[BUFFER];
            Stack<File> folderStack = new Stack<File>();
            String startFolder = inFolder.getAbsolutePath();
            if (inFolder.isDirectory()) {
                ZipEntry folderZipEntry = new ZipEntry(rootFolderName + "/");
                folderZipEntry.setExtra("Directory".getBytes());
                out.putNextEntry(folderZipEntry);
            }
            try {
                do {
                    String parenFolderPath = "";
                    try {
                        parenFolderPath = inFolder.getAbsolutePath().substring(startFolder.length() + 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String[] files = null;
                    if (inFolder.isDirectory()) {
                        files = inFolder.list();
                    } else {
                        files = new String[]{inFolder.getName()};
                        inFolder = new File(startFolder.substring(0, startFolder.length() - files[0].length()));
                        parenFolderPath = null;
                        rootFolderName = null;
                    }
                    for (int i = 0; i < files.length; ++i) {
                        int count;
                        if (new File(inFolder, files[i]).isDirectory()) {
                            folderStack.push(new File(inFolder, files[i]));
                            ZipEntry folderZipEntry = null;
                            folderZipEntry = parenFolderPath != null && parenFolderPath.trim().length() > 0 ? new ZipEntry(rootFolderName + "/" + parenFolderPath + "/" + files[i] + "/") : new ZipEntry(rootFolderName + "/" + files[i] + "/");
                            folderZipEntry.setExtra("Directory".getBytes());
                            out.putNextEntry(folderZipEntry);
                            continue;
                        }
                        in = new BufferedInputStream(new FileInputStream(inFolder.getPath() + "/" + files[i]), BUFFER);
                        ZipEntry fileZipEntry = null;
                        if (rootFolderName == null) {
                            fileZipEntry = new ZipEntry(files[i]);
                        } else if (parenFolderPath != null && parenFolderPath.trim().length() > 0) {
                            fileZipEntry = new ZipEntry(rootFolderName + "/" + parenFolderPath + "/" + files[i]);
                            fileZipEntry.setExtra((rootFolderName + "/" + parenFolderPath).getBytes());
                        } else {
                            fileZipEntry = new ZipEntry(rootFolderName + "/" + files[i]);
                            fileZipEntry.setExtra(rootFolderName.getBytes());
                        }
                        out.putNextEntry(fileZipEntry);
                        while ((count = in.read(data, 0, BUFFER)) != -1) {
                            out.write(data, 0, count);
                        }
                        out.closeEntry();
                    }
                } while ((inFolder = (File)folderStack.pop()) != null);
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
        return baos.toByteArray();
    }

    public static void createZipFileFromByteArrayToLocalDisk(byte[] zippedByteData, File outputDir, String zipFileName) {
        block12: {
            if (zippedByteData == null) {
                zippedByteData = new byte[]{};
            }
            try {
                if (outputDir == null) {
                    outputDir = ZipUtil.getCurrentDir();
                    break block12;
                }
                try {
                    if (outputDir.getAbsolutePath().indexOf(":/") == -1 && outputDir.getAbsolutePath().indexOf(":\\") == -1) {
                        outputDir = new File(ZipUtil.getCurrentDir(), outputDir.getAbsolutePath());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                outputDir = ZipUtil.getCurrentDir();
            }
        }
        try {
            if (!outputDir.exists() || !outputDir.isDirectory()) {
                outputDir.mkdirs();
            }
        }
        catch (Exception e) {
            System.out.println("Writing Bytes Into Current Directory");
            outputDir = ZipUtil.getCurrentDir();
        }
        try {
            BufferedOutputStream outPutDest = null;
            FileOutputStream fos = new FileOutputStream(new File(outputDir.getAbsolutePath(), zipFileName));
            outPutDest = new BufferedOutputStream(fos);
            outPutDest.write(zippedByteData);
            outPutDest.flush();
            outPutDest.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unZipFolder(String zipFile, String outZipFileName) {
        File inFolder = new File(zipFile);
        if (!inFolder.exists()) {
            inFolder = new File(new File(System.getProperty("user.dir")), zipFile);
        }
        File outFile = new File(outZipFileName);
        byte[] data = ZipUtil.getByteArrayFromZipFile(inFolder);
        ZipUtil.createFileStrFromByteArrayToLocalDisk(data, outFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getByteArrayFromZipFile(File zipFileName) {
        int BUFFER = 2048;
        BufferedInputStream in = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] data = new byte[BUFFER];
            try {
                int count;
                in = new BufferedInputStream(new FileInputStream(zipFileName), BUFFER);
                while ((count = in.read(data, 0, BUFFER)) != -1) {
                    baos.write(data, 0, count);
                }
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
            baos.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                baos.close();
            }
            catch (Exception exception) {}
        }
        return baos.toByteArray();
    }

    public static void createFileStrFromByteArrayToLocalDisk(byte[] zippedByteData, File outputDir) {
        block26: {
            if (zippedByteData == null) {
                zippedByteData = new byte[]{};
            }
            try {
                if (outputDir == null) {
                    outputDir = new File(System.getProperty("user.dir"));
                    break block26;
                }
                try {
                    if (outputDir.getAbsolutePath().indexOf(":/") == -1 && outputDir.getAbsolutePath().indexOf(":\\") == -1) {
                        outputDir = new File(new File(System.getProperty("user.dir")), outputDir.getAbsolutePath());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                outputDir = new File(System.getProperty("user.dir"));
            }
        }
        try {
            if (!outputDir.exists() || !outputDir.isDirectory()) {
                outputDir.mkdirs();
            }
        }
        catch (Exception e) {
            outputDir = new File(System.getProperty("user.dir"));
        }
        try {
            ZipEntry entry;
            int BUFFER = 2048;
            BufferedOutputStream outPutDest = null;
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new ByteArrayInputStream(zippedByteData)));
            while ((entry = zis.getNextEntry()) != null) {
                String extraInfo = "file";
                if (entry.getExtra() != null) {
                    extraInfo = new String(entry.getExtra());
                }
                if (extraInfo.equals("Directory")) {
                    File dir = new File(outputDir.getAbsolutePath(), entry.getName());
                    dir.mkdirs();
                    continue;
                }
                try {
                    int count;
                    File dir;
                    byte[] data = new byte[BUFFER];
                    FileOutputStream fos = null;
                    int indx = entry.getName().lastIndexOf(47);
                    if (indx == -1) {
                        indx = entry.getName().lastIndexOf(92);
                    }
                    String fileName = entry.getName().substring(indx + 1);
                    if (entry.getExtra() == null) {
                        if (!fileName.equals("UnzipFileFolder.exe.zip")) {
                            if (entry.isDirectory()) {
                                dir = new File(outputDir.getAbsolutePath(), entry.getName());
                                dir.mkdirs();
                            } else {
                                fos = new FileOutputStream(new File(outputDir.getAbsolutePath(), entry.getName()));
                            }
                        }
                    } else if (entry.isDirectory()) {
                        dir = new File(outputDir.getAbsolutePath(), entry.getName());
                        dir.mkdirs();
                    } else {
                        fos = new FileOutputStream(new File(outputDir.getAbsolutePath(), entry.getName()));
                    }
                    outPutDest = new BufferedOutputStream(fos, BUFFER);
                    while ((count = zis.read(data, 0, BUFFER)) != -1) {
                        outPutDest.write(data, 0, count);
                    }
                    outPutDest.flush();
                    outPutDest.close();
                }
                catch (Exception exception) {}
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<File> getFiles(File file) {
        ArrayList<File> files = new ArrayList<File>();
        try {
            FileInputStream input = new FileInputStream(file);
            ZipInputStream zip = new ZipInputStream(input);
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                System.out.println(entry);
                files.add(file);
            }
            zip.close();
            ((InputStream)input).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return files;
    }

    public static File getCurrentDir() {
        if (currentDir == null) {
            try {
                Process p = Runtime.getRuntime().exec("cmd /c cd");
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String tempS = null;
                while ((tempS = stdInput.readLine()) != null) {
                    tempS = tempS.replace('\\', '/');
                    currentDir = new File(tempS);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
            if (!currentDir.exists()) {
                currentDir = new File(System.getProperty("user.dir"));
            }
        }
        return currentDir;
    }

    public static void setCurrentDir(File currentDir) {
        ZipUtil.currentDir = currentDir;
    }

    public void zip(List<File> listFiles, String destZipFile) throws FileNotFoundException, IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destZipFile));
        for (File file : listFiles) {
            if (file.isDirectory()) {
                this.zipDirectory(file, file.getName(), zos);
                continue;
            }
            this.zipFile(file, zos);
        }
        zos.flush();
        zos.close();
    }

    public void zip(String[] files, String destZipFile) throws FileNotFoundException, IOException {
        ArrayList<File> listFiles = new ArrayList<File>();
        for (int i = 0; i < files.length; ++i) {
            listFiles.add(new File(files[i]));
        }
        this.zip(listFiles, destZipFile);
    }

    private void zipDirectory(File folder, String parentFolder, ZipOutputStream zos) throws FileNotFoundException, IOException {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                this.zipDirectory(file, parentFolder + "/" + file.getName(), zos);
                continue;
            }
            zos.putNextEntry(new ZipEntry(parentFolder + "/" + file.getName()));
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            long bytesRead = 0L;
            byte[] bytesIn = new byte[4096];
            int read = 0;
            while ((read = bis.read(bytesIn)) != -1) {
                zos.write(bytesIn, 0, read);
                bytesRead += (long)read;
            }
            zos.closeEntry();
        }
    }

    private void zipFile(File file, ZipOutputStream zos) throws FileNotFoundException, IOException {
        zos.putNextEntry(new ZipEntry(file.getName()));
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        long bytesRead = 0L;
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = bis.read(bytesIn)) != -1) {
            zos.write(bytesIn, 0, read);
            bytesRead += (long)read;
        }
        zos.closeEntry();
    }

    public static void unzip(String zipFilePath, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                ZipUtil.extractFile(zipIn, filePath);
            } else {
                File dir = new File(filePath);
                dir.mkdir();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    public static String fileUnCompress(String formReadFileName) throws Exception {
        int i;
        FileInputStream fin = new FileInputStream(formReadFileName);
        InflaterInputStream in = new InflaterInputStream(fin);
        String data = "";
        while ((i = in.read()) != -1) {
            data = data + (char)i;
        }
        fin.close();
        in.close();
        return data;
    }

    public static boolean fileCompress(String formReadFileName, String toWriteFileName) throws IOException {
        int i;
        FileInputStream fin = new FileInputStream(formReadFileName);
        FileOutputStream fout = new FileOutputStream(toWriteFileName);
        DeflaterOutputStream out = new DeflaterOutputStream(fout);
        while ((i = fin.read()) != -1) {
            out.write((byte)i);
            out.flush();
        }
        fin.close();
        out.close();
        return true;
    }

    public static String loadCompressFile(File formReadFileName, File toWriteFileName) throws Exception {
        int i;
        FileInputStream fin = new FileInputStream(formReadFileName);
        InflaterInputStream in = new InflaterInputStream(fin);
        FileOutputStream fout = new FileOutputStream(toWriteFileName);
        String data = "";
        while ((i = in.read()) != -1) {
            fout.write((byte)i);
            fout.flush();
            data = "" + (char)i;
        }
        fin.close();
        fout.close();
        in.close();
        return data;
    }

    public static String loadCompressFile(String formReadFileName) throws Exception {
        int i;
        FileInputStream fin = new FileInputStream(formReadFileName);
        InflaterInputStream in = new InflaterInputStream(fin);
        String data = "";
        while ((i = in.read()) != -1) {
            data = data + (char)i;
        }
        fin.close();
        in.close();
        return data;
    }

    public static ArrayList<?> loadFilesFromJarOrDirectly(String dirPath, URL dirUrl) {
        ArrayList<InputStream> inputStreamArray;
        block11: {
            inputStreamArray = new ArrayList<InputStream>();
            try {
                URLConnection urlConnection = dirUrl.openConnection();
                if (urlConnection instanceof JarURLConnection) {
                    JarURLConnection jarURLConnection = (JarURLConnection)urlConnection;
                    JarFile jarFile = jarURLConnection.getJarFile();
                    Enumeration<JarEntry> enm = jarFile.entries();
                    String alternateDirPath = dirPath;
                    if (dirPath.length() > 1 && dirPath.startsWith("/")) {
                        alternateDirPath = dirPath.substring(1);
                    }
                    while (enm.hasMoreElements()) {
                        JarEntry jarEntry = enm.nextElement();
                        if (jarEntry.isDirectory() || !jarEntry.getName().startsWith(dirPath) && !jarEntry.getName().startsWith(alternateDirPath)) continue;
                        System.out.println(jarFile.getName());
                        inputStreamArray.add(jarFile.getInputStream(jarEntry));
                    }
                    break block11;
                }
                URI uri = null;
                try {
                    uri = new URI(dirUrl.toString());
                }
                catch (URISyntaxException e) {
                    return inputStreamArray;
                }
                File dirOrFile = new File(uri);
                if (dirOrFile.isDirectory()) {
                    File[] files = dirOrFile.listFiles();
                    if (files != null) {
                        for (int i = 0; i < files.length; ++i) {
                            FileInputStream fileInputStream = new FileInputStream(files[i]);
                            inputStreamArray.add(fileInputStream);
                        }
                    }
                } else {
                    FileInputStream fileInputStream = new FileInputStream(dirOrFile);
                    inputStreamArray.add(fileInputStream);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Could Not load directory from directory " + dirPath, e);
            }
        }
        return inputStreamArray;
    }

    public static void main(String[] args) throws IOException {
        byte[] zippedByteData = Base64.decodeBase64((String)new String(Files.readAllBytes(new File("D:/fileBytes.txt").toPath())));
        System.out.println(zippedByteData.length);
        ZipUtil.createFileStrFromByteArrayToLocalDisk(zippedByteData, null);
    }
}

