/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.casting.CastingUtil;
import org.brijframework.util.reflect.FieldUtil;
import org.brijframework.util.reflect.InstanceUtil;
import org.brijframework.util.reflect.MethodUtil;
import org.brijframework.util.reflect.ParamUtil;
import org.brijframework.util.support.ReflectionAccess;
import org.brijframework.util.validator.ValidationUtil;

public abstract class LogicUnit {
    public static <T> T collectionMethod(Collection _collection, String _property, Object ... _objects) {
        Assertion.notNull(_collection, "this arg is required; it must not be null collection");
        Assertion.notNull(_property, "this arg is required; it must not be null property");
        Collection returncollection = (Collection)InstanceUtil.getInstance(_collection.getClass(), new Object[0]);
        for (Object object : _collection) {
            Class<?>[] classes = ParamUtil.paramClasses(_objects);
            Method method = MethodUtil.getMethod(object.getClass(), _property, classes);
            if (method == null) continue;
            try {
                returncollection.add(method.invoke(object, _objects));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {}
        }
        return (T)returncollection;
    }

    public static <T> T collectionField(Collection _collection, String _property) {
        Assertion.notNull(_collection, "this arg is required; it must not be null collection");
        Assertion.notNull(_property, "this arg is required; it must not be null property");
        Collection returncollection = (Collection)InstanceUtil.getInstance(_collection.getClass(), new Object[0]);
        for (Object object : _collection) {
            Field field = FieldUtil.getField(object.getClass(), _property);
            if (field == null) continue;
            try {
                returncollection.add(field.get(object));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {}
        }
        return (T)returncollection;
    }

    public static <T> T callMethod(Object object, String _method, Object ... objects) {
        Method method = MethodUtil.getMethod(object.getClass(), _method, new Class[0]);
        return LogicUnit.callMethod(object, method, objects);
    }

    public static <T> T callMethod(Object object, Method method, Object ... objects) {
        Assertion.notNull(method, "Method should not be null");
        try {
            return (T)method.invoke(object, objects);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T callMethod(Class<?> _class, String _method, Object ... objects) {
        Method method = MethodUtil.getMethod(_class, _method, new Class[0]);
        return LogicUnit.callMethod(method, objects);
    }

    public static <T> T callMethod(Method method, Object ... objects) {
        Assertion.notNull(method, "Method should not be null");
        try {
            return (T)method.invoke(null, objects);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T getField(Object object, String property) {
        Field field = FieldUtil.getField(object.getClass(), property);
        return LogicUnit.getField(object, field);
    }

    public static <T> T setAllField(Object object, Map<String, Object> map) {
        for (String key : map.keySet()) {
            LogicUnit.setField(object, key, map.get(key));
        }
        return (T)object;
    }

    public static <T> T getField(Object object, Field field) {
        Assertion.notNull(field, "Field should not be null");
        try {
            field.setAccessible(true);
            return (T)field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> getAllField(Object _object, String ... _keys) {
        HashMap<String, Object> returnValues = new HashMap<String, Object>();
        List<String> keyList = _keys.length > 0 ? Arrays.asList(_keys) : FieldUtil.getFieldList(_object.getClass());
        for (String key : keyList) {
            returnValues.put(key, LogicUnit.getField(_object, key));
        }
        return returnValues;
    }

    public static <T> T setField(Object _object, String property, Object _param) {
        if (_object == null) {
            return null;
        }
        if (!ValidationUtil.isValidObject((Object)property)) {
            return null;
        }
        Field _field = FieldUtil.getField(_object.getClass(), property);
        if (_field == null) {
            return null;
        }
        return LogicUnit.setField(_object, _field, _param);
    }

    public static <T> T setField(Object object, String property, Object param, ReflectionAccess accessLevel) {
        Field field = FieldUtil.getField(object.getClass(), property, accessLevel);
        return LogicUnit.setField(object, field, param);
    }

    public static <T> T setField(Object _object, Field _field, Object _param) {
        if (!ValidationUtil.isValidObject(_object, _field)) {
            return null;
        }
        try {
            Class paramType = null;
            Class<?> returnType = _field.getType();
            if (ValidationUtil.isEqualClass(Collection.class, _field.getType())) {
                ParameterizedType listType = (ParameterizedType)_field.getGenericType();
                paramType = (Class)listType.getActualTypeArguments()[0];
                returnType = LogicUnit.getField(_object, _field).getClass();
            }
            Object atual = CastingUtil.castObject(_param, returnType, paramType);
            _field.set(_object, atual);
            return atual;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }
}

