/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.runtime;

import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Scanner;
import org.brijframework.util.validator.ValidationUtil;

public abstract class ConsoleUtil {
    public static PrintStream consoleOutStream;
    public static PrintStream consoleErrStream;
    public static PrintStream outputLogStream;
    static boolean taskClosed;
    static Scanner scanner;
    static Console console;

    public static String getPassword() {
        System.out.println("Please Enter Password: ");
        char[] input = console.readPassword();
        String password = new String(input);
        if (password == null && password.isEmpty()) {
            System.err.println("Wong Input");
            return ConsoleUtil.getPassword();
        }
        return password;
    }

    public static String getPassword(String regex) {
        System.out.println("Please Enter Password: ");
        char[] input = console.readPassword();
        String password = new String(input);
        if (password == null && password.isEmpty() && password.matches(regex)) {
            System.err.println("Wong Input");
            return ConsoleUtil.getPassword();
        }
        return password;
    }

    public static String getNumber() {
        System.out.println("Please Enter Number : ");
        String input = scanner.next();
        if (!ValidationUtil.isNumber(input)) {
            System.err.println("Wong Input  ");
            return ConsoleUtil.getNumber();
        }
        return input;
    }

    public String getBinaryNumber() {
        System.out.println("Please Enter Binary Number : ");
        String input = scanner.next();
        if (!ValidationUtil.isBinaryNumber(input)) {
            System.err.println("Wong Input  ");
            return this.getBinaryNumber();
        }
        return input;
    }

    public String getOctalNumber() {
        System.out.println("Please Enter Octol Number : ");
        String input = scanner.next();
        if (!ValidationUtil.isOctalNumber(input)) {
            System.err.println("Wong Input");
            return this.getOctalNumber();
        }
        return input;
    }

    public static String getHexaNumber() {
        System.out.println("Please Enter Hex String: ");
        String input = scanner.next();
        if (!ValidationUtil.isHexaNumber(input)) {
            System.err.println("Wong Input  ");
            return ConsoleUtil.getHexaNumber();
        }
        return input;
    }

    public static String getString() {
        System.out.println("Please Enter String : ");
        String input = scanner.next();
        if (!ValidationUtil.isAlphabet(input)) {
            System.err.println("Wong Input  ");
            return ConsoleUtil.getString();
        }
        return input;
    }

    public static String getDoubleNumber() {
        System.out.println("Please Enter Double : ");
        String input = scanner.next();
        if (!ValidationUtil.isDouble(input)) {
            System.err.println("Wong Input  ");
            return ConsoleUtil.getDoubleNumber();
        }
        return input;
    }

    public static char getChar() {
        System.out.println("Please Enter Only Char : ");
        String input = scanner.next();
        if (!ValidationUtil.isCharecter(input)) {
            System.err.println("Wong Input  ");
            return ConsoleUtil.getChar();
        }
        return input.charAt(0);
    }

    public static void main(String[] args) {
        consoleOutStream = System.out;
        consoleErrStream = System.err;
        ConsoleUtil.log();
        try {
            taskClosed = false;
            ConsoleUtil.listOfProcesses();
            System.out.println("\n\n**************************** Closing cmd.exe   ************************************");
            ConsoleUtil.killProcesses();
            if (!taskClosed) {
                System.out.println("No cmd.exe found to be closed");
            }
            System.out.println("** Finished @ " + new Date() + "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String outPutPath() {
        String formatedDate = "";
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM_dd_yyyy");
            formatedDate = dateFormat.format(new Date());
            String usrDir = System.getProperty("user.dir");
            File log = new File(usrDir + "/log");
            if (!log.exists()) {
                log.mkdir();
            }
            String[] logList = log.list();
            for (int i = 0; i < logList.length; ++i) {
                long totalTime = 604800000L;
                File f = new File(log.getAbsolutePath() + "/" + logList[i]);
                if (totalTime > System.currentTimeMillis() - f.lastModified()) continue;
                f.delete();
            }
            File logFile = new File(log, "log_" + formatedDate + ".txt");
            return logFile.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return formatedDate + ".txt";
        }
    }

    public static void log() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(ConsoleUtil.outPutPath(), true);
            outputLogStream = new PrintStream(fileOutputStream, true);
            consoleOutStream.println("Output has been redirected to file " + ConsoleUtil.outPutPath());
            System.setOut(outputLogStream);
            System.setErr(outputLogStream);
            System.out.println("\r\n***************************************************************");
            System.out.println("Started @ " + new Date());
            System.out.println("***************************************************************");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String killProcesses() throws IOException {
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        ArrayList<String> command = new ArrayList<String>();
        command.add("taskkill");
        command.add("/f");
        command.add("/im");
        command.add("cmd.exe");
        try {
            String line;
            ProcessBuilder builder = new ProcessBuilder(command);
            Process process = builder.start();
            is = process.getInputStream();
            isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            StringBuilder sw = new StringBuilder();
            while ((line = br.readLine()) != null) {
                System.out.println(line);
                sw.append(line.trim());
                sw.append(System.getProperty("lineSeparator"));
                taskClosed = true;
            }
            String string = sw.toString();
            return string;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String listOfProcesses() throws IOException {
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        ArrayList<String> command = new ArrayList<String>();
        command.add("wmic");
        command.add("process");
        command.add("where");
        command.add("name='cmd.exe'");
        command.add("get");
        command.add("name,");
        command.add("processid");
        try {
            String line;
            ProcessBuilder builder = new ProcessBuilder(command);
            Process process = builder.start();
            is = process.getInputStream();
            isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            StringBuilder sw = new StringBuilder();
            while ((line = br.readLine()) != null) {
                System.out.println(line);
                sw.append(line.trim());
                sw.append(System.getProperty("lineSeparator"));
            }
            String string = sw.toString();
            return string;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    static {
        taskClosed = false;
        scanner = new Scanner(System.in);
        console = System.console();
    }
}

