/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.accessor;

import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class EventAccessorUtil {
    private EventAccessorUtil() {
    }

    public static boolean containEvent(Object bean, String name) {
        try {
            return EventAccessorUtil.findEvent(bean, name) != null;
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Method findEvent(Object bean, String name) throws IntrospectionException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        EventSetDescriptor[] events;
        BeanInfo beaninfo = Introspector.getBeanInfo(bean.getClass());
        for (EventSetDescriptor event : events = beaninfo.getEventSetDescriptors()) {
            Method addMethod = event.getAddListenerMethod();
            if (addMethod == null || !addMethod.getName().contentEquals(name)) continue;
            return addMethod;
        }
        for (EventSetDescriptor event : events) {
            Method removeMethod = event.getRemoveListenerMethod();
            if (removeMethod == null || !removeMethod.getName().contentEquals(name)) continue;
            return removeMethod;
        }
        for (EventSetDescriptor event : events) {
            Method getMethod = event.getGetListenerMethod();
            if (getMethod == null || !getMethod.getName().contentEquals(name)) continue;
            return getMethod;
        }
        return null;
    }
}

