/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.reflect.FieldUtil;
import org.brijframework.util.validator.ValidationUtil;

public abstract class ClassUtil {
    public static ParameterizedType getParameterizedType(Class<?> target) {
        Type[] types = ClassUtil.getGenericType(target);
        if (types.length > 0 && types[0] instanceof ParameterizedType) {
            return (ParameterizedType)types[0];
        }
        return null;
    }

    public static Type[] getParameterizedTypes(Class<?> target) {
        Type[] types = ClassUtil.getGenericType(target);
        if (types.length > 0 && types[0] instanceof ParameterizedType) {
            return ((ParameterizedType)types[0]).getActualTypeArguments();
        }
        return null;
    }

    public static Type[] getGenericType(Class<?> target) {
        if (target == null) {
            return new Type[0];
        }
        Type[] types = target.getGenericInterfaces();
        if (types.length > 0) {
            return types;
        }
        Type type = target.getGenericSuperclass();
        if (type != null && type instanceof ParameterizedType) {
            return new Type[]{type};
        }
        return new Type[0];
    }

    public static boolean isClass(String _className) {
        if (_className == null) {
            return false;
        }
        if (Character.TYPE.getName().equals(_className)) {
            return true;
        }
        if (Byte.TYPE.getName().equals(_className)) {
            return true;
        }
        if (Short.TYPE.getName().equals(_className)) {
            return true;
        }
        if (Integer.TYPE.getName().equals(_className)) {
            return true;
        }
        if (Long.TYPE.getName().equals(_className)) {
            return true;
        }
        if (Double.TYPE.getName().equals(_className)) {
            return true;
        }
        if (Float.TYPE.getName().equals(_className)) {
            return true;
        }
        try {
            Class.forName(_className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Class<?> getClass(String _className) {
        Assertion.notNull(_className, "this class name is required; it must not be null");
        if (Character.TYPE.getName().equals(_className)) {
            return Character.TYPE;
        }
        if (Byte.TYPE.getName().equals(_className)) {
            return Byte.TYPE;
        }
        if (Short.TYPE.getName().equals(_className)) {
            return Short.TYPE;
        }
        if (Integer.TYPE.getName().equals(_className)) {
            return Integer.TYPE;
        }
        if (Long.TYPE.getName().equals(_className)) {
            return Long.TYPE;
        }
        if (Double.TYPE.getName().equals(_className)) {
            return Double.TYPE;
        }
        if (Float.TYPE.getName().equals(_className)) {
            return Float.TYPE;
        }
        try {
            return Class.forName(_className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public Class<?> getSuperClass(Class<?> _class) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        Class<?> superClass = null;
        while (!_class.getSimpleName().contentEquals(Object.class.getSimpleName())) {
            superClass = _class;
        }
        return superClass;
    }

    public Class<?> getSuperInterface(Class<?> _class) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        Class<?> superClass = null;
        while (!_class.getSimpleName().contentEquals(Object.class.getSimpleName()) && _class.isInterface()) {
            superClass = _class;
        }
        return superClass;
    }

    public static List<Class<?>> getAllSuperInterface(Class<?> _class) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        ArrayList interfaces = new ArrayList();
        for (Class<?> c : ClassUtil.getAllSuperClass(_class)) {
            for (Class<?> i : c.getInterfaces()) {
                interfaces.add(i);
            }
        }
        return interfaces;
    }

    public static List<Class<?>> getAllSuperClass(Class<?> _class) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        LinkedList _classes = new LinkedList();
        Class<?> _supper = _class.getSuperclass();
        while (!_supper.getSimpleName().contentEquals(Object.class.getSimpleName())) {
            _classes.add(_supper);
            _supper = _supper.getSuperclass();
        }
        return _classes;
    }

    public static boolean isContainInterface(Class<?> _class, Class<?> _interface) {
        Assertion.notNull(_class, "this class is required; it must not be null left");
        Assertion.notNull(_class, "this class is required; it must not be null rigth");
        return ClassUtil.getAllSuperInterface(_class).contains(_interface);
    }

    public static Class<?> collectionParamType(Field _field) {
        Assertion.notNull(_field, "this field is required; it must not be null");
        if (ClassUtil.isCollection(_field.getType())) {
            ParameterizedType listType = (ParameterizedType)_field.getGenericType();
            return (Class)listType.getActualTypeArguments()[0];
        }
        return null;
    }

    public static Class<?> collectionParamType(Method _field) {
        Assertion.notNull(_field, "this field is required; it must not be null");
        if (ClassUtil.isCollection(_field.getReturnType())) {
            ParameterizedType listType = (ParameterizedType)_field.getGenericReturnType();
            return (Class)listType.getActualTypeArguments()[0];
        }
        return null;
    }

    public static Class<?> collectionParamType(AccessibleObject _field) {
        Assertion.notNull(_field, "this field is required; it must not be null");
        if (_field instanceof Method) {
            return ClassUtil.collectionParamType((Method)_field);
        }
        return ClassUtil.collectionParamType((Field)_field);
    }

    public static Class<?> getCollectionType(Collection<?> _collection) {
        Assertion.notNull(_collection, "this arg is required; it must not be null");
        if (_collection.size() > 0) {
            _collection.toArray()[0].getClass();
        }
        return null;
    }

    public static boolean isArrayField(Field _field) {
        Assertion.notNull(_field, "this field is required; it must not be null");
        return Array.class.isAssignableFrom(_field.getType());
    }

    public static boolean isCollection(Class<?> _class) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        return List.class.isAssignableFrom(_class) || Set.class.isAssignableFrom(_class) || Queue.class.isAssignableFrom(_class) || Map.class.isAssignableFrom(_class);
    }

    public static List<Field> getAllRelField(Class<?> _class) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : FieldUtil.getAllField(_class)) {
            if (ValidationUtil.isPrimative(field.getType()).booleanValue()) continue;
            fields.add(field);
        }
        return fields;
    }

    public static void main(String[] args) {
    }
}

