/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.brijframework.util.accessor.PropertyAccessorUtil;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.reflect.ClassUtil;
import org.brijframework.util.reflect.ParamUtil;

public abstract class InstanceUtil {
    public static Object getImpletationInstanse(Class<?> cls) {
        if (List.class.isAssignableFrom(cls)) {
            return new ArrayList();
        }
        if (Set.class.isAssignableFrom(cls)) {
            return new HashSet();
        }
        if (Map.class.isAssignableFrom(cls)) {
            return new HashMap();
        }
        return InstanceUtil.getInstance(cls, new Object[0]);
    }

    public static boolean isAssignable(Class<?> cls) {
        if (null == cls) {
            return false;
        }
        return !Modifier.isAbstract(cls.getModifiers()) && !Modifier.isInterface(cls.getModifiers());
    }

    private static boolean isValidParam(Constructor<?> _constructor, Object ... _params) {
        if (_params == null && _constructor.getParameterTypes().length == 0) {
            return true;
        }
        if (_params.length == 0 && _constructor.getParameterTypes().length == 0) {
            return true;
        }
        return ParamUtil.isValidParam(_constructor, _params);
    }

    public static Constructor<?> constructor(Class<?> _class, Object ... params) {
        for (Constructor<?> constructor : _class.getDeclaredConstructors()) {
            if (!InstanceUtil.isValidParam(constructor, params)) continue;
            return constructor;
        }
        return null;
    }

    public static <T> T getInstance(String _className, Object ... params) {
        Assertion.notNull(_className, "this class name is required; it must not be null");
        return (T)InstanceUtil.getInstance(ClassUtil.getClass(_className), params);
    }

    public static <T> T getInstance(Constructor<?> constructor, Object ... params) {
        Assertion.notNull(constructor, "this class name is required; it must not be null");
        try {
            return (T)constructor.newInstance(params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T getInstance(Class<T> _class, Object ... params) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        if (_class.isInterface() || Modifier.isAbstract(_class.getModifiers())) {
            return null;
        }
        try {
            if (params != null && params.length > 0) {
                Constructor<?> constructor = InstanceUtil.constructor(_class, params);
                Assertion.notNull(constructor, "constructor not found. this is required");
                return (T)constructor.newInstance(params);
            }
            return _class.newInstance();
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T getInstance(Class<?> _class, Map _map) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        Assertion.notNull(_map, "this arg is required; it must not be null");
        Object object = InstanceUtil.getInstance(_class, new Object[0]);
        PropertyAccessorUtil.setProperties(object, _map);
        return (T)object;
    }

    public static <T> T getInstance(Class<?> _class, Map<String, Object> _map, Object ... params) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        Assertion.notNull(_map, "this arg is required; it must not be null");
        Object object = InstanceUtil.getInstance(_class, params);
        PropertyAccessorUtil.setProperties(object, _map);
        return (T)object;
    }

    public static <T> T getSingletonInstance(Class<?> _class, Object ... params) {
        Assertion.notNull(_class, "this class is required; it must not be null");
        try {
            Constructor<?> constructor = InstanceUtil.constructor(_class, params);
            Assertion.notNull(constructor, "constructor not found. this is required for " + _class);
            constructor.setAccessible(true);
            return (T)constructor.newInstance(params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T getSingletonInstance(String _class, Object ... params) {
        Assertion.notNull(_class, "this class name is required; it must not be null");
        return InstanceUtil.getSingletonInstance(ClassUtil.getClass(_class), params);
    }

    public static <T> T getSingletonInstance(Class<?> _class, Map<String, Object> _map, Object ... _params) {
        Assertion.notNull(_class, "this class name is required; it must not be null");
        Assertion.notNull(_map, "this arg is required; it must not be null");
        T object = InstanceUtil.getSingletonInstance(_class, _params);
        PropertyAccessorUtil.setProperties(object, _map);
        return object;
    }

    public static Map<String, Object> getAllWithOutRelField(Object object) {
        return null;
    }
}

