/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ThreadUtil {
    public static void sleepForSeconds(int seconds) throws InterruptedException {
        Thread.sleep((long)seconds * 1000L);
    }

    public static boolean intrrupted(long id) throws InterruptedException {
        Set<Thread> set = Thread.getAllStackTraces().keySet();
        for (Thread thread : set) {
            if (thread.getId() != id) continue;
            Thread.interrupted();
            return true;
        }
        return false;
    }

    public static List<Thread> getThreadGroup(String name) throws InterruptedException {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        Set<Thread> set = Thread.getAllStackTraces().keySet();
        for (Thread thread : set) {
            if (!thread.getThreadGroup().getName().contentEquals(name)) continue;
            threads.add(thread);
        }
        return threads;
    }

    public static List<Thread> getAliveThreadGroup(String name) throws InterruptedException {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        Set<Thread> set = Thread.getAllStackTraces().keySet();
        for (Thread thread : set) {
            if (!thread.getThreadGroup().getName().contentEquals(name) || !thread.isAlive()) continue;
            threads.add(thread);
        }
        return threads;
    }

    public static List<Thread> getALiveThreadGroup(String name, Thread.State state) throws InterruptedException {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        Set<Thread> set = Thread.getAllStackTraces().keySet();
        for (Thread thread : set) {
            if (!thread.getThreadGroup().getName().contentEquals(name) || !thread.isAlive() || !thread.getState().equals((Object)state)) continue;
            threads.add(thread);
        }
        return threads;
    }

    public static void sleepForSoManySeconds(int seconds) {
        try {
            Thread.sleep((long)seconds * 1000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static void sleepForSoManyMilliSeconds(int milliSeconds) {
        try {
            Thread.sleep(milliSeconds);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static void runGc(int n) {
        for (int i = 0; i < n; ++i) {
            Runtime.getRuntime().gc();
            ThreadUtil.sleepForSoManySeconds(1);
        }
    }
}

