/*
 * Decompiled with CFR 0.152.
 */
package io.github.graphdsl.codegen;

import io.github.graphdsl.codegen.BaseTypeMapper;
import io.github.graphdsl.codegen.MutationDslModelImpl;
import io.github.graphdsl.codegen.st.STContents;
import io.github.graphdsl.codegen.st.STUtilsKt;
import io.github.graphdsl.schema.GraphDslSchema;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"MUTATION_DSL_TEMPLATE", "", "mutationDslGen", "Lio/github/graphdsl/codegen/st/STContents;", "pkg", "mutationDef", "Lio/github/graphdsl/schema/GraphDslSchema$Object;", "baseTypeMapper", "Lio/github/graphdsl/codegen/BaseTypeMapper;", "codegen"})
public final class MutationDslGenKt {
    @NotNull
    private static final String MUTATION_DSL_TEMPLATE = STUtilsKt.stTemplate((String)"\n@file:Suppress(\"warnings\")\n\npackage <mdl.pkg>\n\n/**\n * Creates a GraphQL mutation string using a type-safe DSL.\n *\n * @param name Optional operation name for the mutation\n * @param block DSL block to define mutation fields\n * @return The GraphQL mutation string\n */\nfun mutation(name: String? = null, block: MutationDslBuilder.() -> Unit): String {\n    val builder = MutationDslBuilder()\n    builder.block()\n    val operationName = name?.let { \" $it\" } ?: \"\"\n    return \"mutation$operationName { ${builder.build()} }\"\n}\n\n/**\n * DSL builder for constructing GraphQL mutations.\n */\nclass MutationDslBuilder internal constructor() {\n    private val fields = mutableListOf\\<String>()\n\n    private fun addField(name: String) {\n        fields.add(name)\n    }\n\n<mdl.scalarFields: { f |\n    fun <f.escapedName>(<f.parameterSignature>) {\n        val aliasPrefix = if (alias != null) alias + \": \" else \"\"\n<if(f.hasArgs)>\n        val args = listOf(<f.parameterSerializers>).joinToString(\", \")\n        addField(aliasPrefix + \"<f.fieldName>($args)\")\n<else>\n        addField(aliasPrefix + \"<f.fieldName>\")\n<endif>\n    \\}\n}; separator=\"\\n\">\n\n<mdl.complexFields: { f |\n    fun <f.escapedName>(<f.parameterSignature>, block: <f.selectionBuilderType>.() -> Unit) {\n        val aliasPrefix = if (alias != null) alias + \": \" else \"\"\n        val nestedBuilder = <f.selectionBuilderType>()\n        nestedBuilder.block()\n<if(f.hasInputArgs)>\n        val argsMap = nestedBuilder.buildArgs()\n        val argsStr = serializeArgsMap(argsMap)\n        val argsSection = if (argsStr.isNotEmpty()) \"($argsStr)\" else \"\"\n        addField(aliasPrefix + \"<f.fieldName>\" + argsSection + \" { \" + nestedBuilder.build() + \" \\}\")\n<elseif(f.serializeArgsInline)>\n        val args = listOf(<f.parameterSerializers>).joinToString(\", \")\n        addField(aliasPrefix + \"<f.fieldName>($args) { \" + nestedBuilder.build() + \" \\}\")\n<else>\n        addField(aliasPrefix + \"<f.fieldName> { \" + nestedBuilder.build() + \" \\}\")\n<endif>\n    \\}\n}; separator=\"\\n\">\n\n    internal fun build(): String = fields.joinToString(\" \")\n\n    private fun serializeArgsMap(args: Map\\<String, Any?>): String {\n        return args.entries.joinToString(\", \") { (k, v) -> \"$k: ${serializeValue(v)}\" }\n    }\n\n    private fun serializeValue(value: Any?): String {\n        return when (value) {\n            null -> \"null\"\n            is String -> \"\\\\\"\" + value.replace(\"\\\\\\\\\", \"\\\\\\\\\\\\\\\\\").replace(\"\\\\\"\", \"\\\\\\\\\\\\\"\") + \"\\\\\"\"\n            is Boolean -> value.toString()\n            is Number -> value.toString()\n            is Enum\\<*> -> value.name\n            is Map\\<*, *> -> value.entries.joinToString(\", \", \"{\", \"}\") { (k, v) ->\n                \"$k: ${serializeValue(v)}\"\n            }\n            is List\\<*> -> \"[\" + value.joinToString(\", \") { serializeValue(it) } + \"]\"\n            else -> value.toString()\n        }\n    }\n}\n");

    @NotNull
    public static final STContents mutationDslGen(@NotNull String pkg, @NotNull GraphDslSchema.Object mutationDef, @NotNull BaseTypeMapper baseTypeMapper) {
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)mutationDef, (String)"mutationDef");
        Intrinsics.checkNotNullParameter((Object)baseTypeMapper, (String)"baseTypeMapper");
        return new STContents(MUTATION_DSL_TEMPLATE, (Object)new MutationDslModelImpl(pkg, mutationDef, baseTypeMapper));
    }
}

