/*
 * Decompiled with CFR 0.152.
 */
package io.github.graphdsl.codegen;

import io.github.graphdsl.codegen.ZipUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0007\u001a\u00020\u0004*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e*\u00020\fJ'\u0010\u000f\u001a\u00020\u0004*\u00020\f2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\f0\u0011\"\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u0012J1\u0010\u000f\u001a\u00020\u0004*\u00020\f2\b\b\u0002\u0010\u0013\u001a\u00020\n2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\f0\u0011\"\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lio/github/graphdsl/codegen/ZipUtil;", "", "()V", "zeroOutTimestamps", "", "entry", "Ljava/util/zip/ZipEntry;", "addZipEntry", "Ljava/util/zip/ZipOutputStream;", "zipPath", "", "sourceFile", "Ljava/io/File;", "listTopDownFiles", "", "zipAndWriteDirectories", "sources", "", "(Ljava/io/File;[Ljava/io/File;)V", "stripPrefix", "(Ljava/io/File;Ljava/lang/String;[Ljava/io/File;)V", "codegen"})
@SourceDebugExtension(value={"SMAP\nZipUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipUtil.kt\nio/github/graphdsl/codegen/ZipUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1045#2:60\n1855#2,2:61\n*S KotlinDebug\n*F\n+ 1 ZipUtil.kt\nio/github/graphdsl/codegen/ZipUtil\n*L\n26#1:60\n26#1:61,2\n*E\n"})
public final class ZipUtil {
    @NotNull
    public static final ZipUtil INSTANCE = new ZipUtil();

    private ZipUtil() {
    }

    @NotNull
    public final List<File> listTopDownFiles(@NotNull File $this$listTopDownFiles) {
        Intrinsics.checkNotNullParameter((Object)$this$listTopDownFiles, (String)"<this>");
        List<File> list = Files.walk($this$listTopDownFiles.toPath(), new FileVisitOption[0]).map(arg_0 -> ZipUtil.listTopDownFiles$lambda$0(listTopDownFiles.1.INSTANCE, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"walk(toPath()).map(Path:\u2026lect(Collectors.toList())");
        return list;
    }

    public final void zipAndWriteDirectories(@NotNull File $this$zipAndWriteDirectories, File ... sources) {
        Intrinsics.checkNotNullParameter((Object)$this$zipAndWriteDirectories, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        this.zipAndWriteDirectories($this$zipAndWriteDirectories, "", Arrays.copyOf(sources, sources.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void zipAndWriteDirectories(@NotNull File $this$zipAndWriteDirectories, @NotNull String stripPrefix, File ... sources) {
        Intrinsics.checkNotNullParameter((Object)$this$zipAndWriteDirectories, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stripPrefix, (String)"stripPrefix");
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        Closeable closeable = new ZipOutputStream(new FileOutputStream($this$zipAndWriteDirectories));
        Throwable throwable = null;
        try {
            ZipOutputStream out = (ZipOutputStream)closeable;
            boolean bl = false;
            for (File item : sources) {
                if (item == null) continue;
                if (item.isDirectory()) {
                    void $this$forEach$iv;
                    Iterable $this$sortedBy$iv = INSTANCE.listTopDownFiles(item);
                    boolean $i$f$sortedBy = false;
                    $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            File p0 = (File)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)p0.getAbsolutePath());
                            p0 = (File)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.getAbsolutePath())));
                        }
                    });
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        File sourceFile = (File)element$iv;
                        boolean bl2 = false;
                        String zipPath = item.getName() + "/" + FilesKt.relativeTo((File)sourceFile, (File)item);
                        char[] cArray = new char[]{'/'};
                        INSTANCE.addZipEntry(out, StringsKt.trimStart((String)StringsKt.removePrefix((String)zipPath, (CharSequence)stripPrefix), (char[])cArray), sourceFile);
                    }
                    continue;
                }
                String string = item.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"item.name");
                char[] cArray = new char[]{'/'};
                INSTANCE.addZipEntry(out, StringsKt.trimStart((String)StringsKt.removePrefix((String)string, (CharSequence)stripPrefix), (char[])cArray), item);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void zipAndWriteDirectories$default(ZipUtil zipUtil, File file, String string, File[] fileArray, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        zipUtil.zipAndWriteDirectories(file, string, fileArray);
    }

    private final void addZipEntry(ZipOutputStream $this$addZipEntry, String zipPath, File sourceFile) {
        if (sourceFile.isDirectory()) {
            ZipEntry entry = new ZipEntry(zipPath + "/");
            this.zeroOutTimestamps(entry);
            $this$addZipEntry.putNextEntry(entry);
        } else {
            ZipEntry entry = new ZipEntry(zipPath);
            this.zeroOutTimestamps(entry);
            $this$addZipEntry.putNextEntry(entry);
            Files.copy(sourceFile.toPath(), $this$addZipEntry);
        }
        $this$addZipEntry.closeEntry();
    }

    private final void zeroOutTimestamps(ZipEntry entry) {
        entry.setLastAccessTime(FileTime.fromMillis(0L));
        entry.setLastModifiedTime(FileTime.fromMillis(0L));
    }

    private static final File listTopDownFiles$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (File)$tmp0.invoke(p0);
    }
}

