/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.graphQLProcessors;

import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.annotations.processor.retrievers.GraphQLObjectInfoRetriever;
import graphql.annotations.processor.retrievers.GraphQLOutputObjectRetriever;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;

public class GraphQLOutputProcessor {
    private GraphQLObjectInfoRetriever graphQLObjectInfoRetriever;
    private GraphQLOutputObjectRetriever outputObjectRetriever;

    public GraphQLOutputProcessor(GraphQLObjectInfoRetriever graphQLObjectInfoRetriever, GraphQLOutputObjectRetriever outputObjectRetriever) {
        this.graphQLObjectInfoRetriever = graphQLObjectInfoRetriever;
        this.outputObjectRetriever = outputObjectRetriever;
    }

    public GraphQLOutputProcessor() {
        this(new GraphQLObjectInfoRetriever(), new GraphQLOutputObjectRetriever());
    }

    public GraphQLOutputType getOutputTypeOrRef(Class<?> object, ProcessingElementsContainer container) throws GraphQLAnnotationsException {
        String typeName = this.graphQLObjectInfoRetriever.getTypeName(object);
        if (container.getProcessing().contains(typeName)) {
            return new GraphQLTypeReference(typeName);
        }
        return this.outputObjectRetriever.getOutputType(object, container);
    }
}

