/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.connection;

import graphql.annotations.connection.AbstractPaginatedData;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Iterator;

public class SimplePaginatedData<T>
extends AbstractPaginatedData<T> {
    private static final String DUMMY_CURSOR_PREFIX = "simple-cursor";
    private final String prefix;

    public SimplePaginatedData(boolean hasPreviousPage, boolean hasNextPage, Iterable<T> data) {
        this(hasPreviousPage, hasNextPage, data, DUMMY_CURSOR_PREFIX);
    }

    public SimplePaginatedData(boolean hasPreviousPage, boolean hasNextPage, Iterable<T> data, String prefix) {
        super(hasPreviousPage, hasNextPage, data);
        this.prefix = prefix;
    }

    @Override
    public String getCursor(T entity) {
        Object next;
        Iterator iterator = this.data.iterator();
        long offset = 0L;
        while (iterator.hasNext() && !entity.equals(next = iterator.next())) {
            ++offset;
        }
        return this.createCursor(offset);
    }

    private String createCursor(long offset) {
        byte[] bytes = (this.prefix + Long.toString(offset)).getBytes(StandardCharsets.UTF_8);
        return Base64.getEncoder().encodeToString(bytes);
    }
}

