/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.searchAlgorithms;

import graphql.annotations.processor.exceptions.CannotCastMemberException;
import graphql.annotations.processor.retrievers.GraphQLObjectInfoRetriever;
import graphql.annotations.processor.searchAlgorithms.SearchAlgorithm;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.LinkedList;

public class BreadthFirstSearch
implements SearchAlgorithm {
    private GraphQLObjectInfoRetriever graphQLObjectInfoRetriever;

    public BreadthFirstSearch(GraphQLObjectInfoRetriever graphQLObjectInfoRetriever) {
        this.graphQLObjectInfoRetriever = graphQLObjectInfoRetriever;
    }

    @Override
    public boolean isFound(Member member) throws CannotCastMemberException {
        Method method = this.CastToMethod(member);
        LinkedList queue = new LinkedList();
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        queue.add(method.getDeclaringClass());
        do {
            Boolean gqf;
            Class cls = (Class)queue.remove(0);
            try {
                method = cls.getDeclaredMethod(methodName, parameterTypes);
                gqf = GraphQLObjectInfoRetriever.isGraphQLField(method);
                if (gqf != null) {
                    return gqf;
                }
            }
            catch (NoSuchMethodException gqf2) {
                // empty catch block
            }
            gqf = GraphQLObjectInfoRetriever.isGraphQLField(cls);
            if (gqf != null) {
                return gqf;
            }
            for (Class<?> iface : cls.getInterfaces()) {
                queue.add(iface);
            }
            Class nxt = cls.getSuperclass();
            if (nxt == null) continue;
            queue.add(nxt);
        } while (!queue.isEmpty());
        return false;
    }

    private Method CastToMethod(Member member) throws CannotCastMemberException {
        if (!(member instanceof Method)) {
            throw new CannotCastMemberException(member.getName(), "Method");
        }
        return (Method)member;
    }
}

