/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.directives;

import graphql.annotations.directives.AnnotationsDirectiveWiring;
import graphql.annotations.directives.AnnotationsWiringEnvironment;
import graphql.annotations.directives.AnnotationsWiringEnvironmentImpl;
import graphql.annotations.directives.InvalidDirectiveLocationException;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLUnionType;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DirectiveWirer {
    private Map<Class, WiringFunction> functionMap = this.createFunctionsMap();

    private void putInMap(Map<Class, WiringFunction> map, Class clazz, String functionName, Introspection.DirectiveLocation ... locations) {
        map.put(clazz, (d, e, wiring) -> {
            this.assertLocation(d, e, locations);
            AnnotationsWiringEnvironmentImpl environment = new AnnotationsWiringEnvironmentImpl(e, e.getDirective(d.getName()));
            return (GraphQLDirectiveContainer)wiring.getClass().getMethod(functionName, AnnotationsWiringEnvironment.class).invoke((Object)wiring, environment);
        });
    }

    private Map<Class, WiringFunction> createFunctionsMap() {
        HashMap<Class, WiringFunction> functionMap = new HashMap<Class, WiringFunction>();
        this.putInMap(functionMap, GraphQLFieldDefinition.class, "onField", Introspection.DirectiveLocation.FIELD, Introspection.DirectiveLocation.FIELD_DEFINITION);
        this.putInMap(functionMap, GraphQLObjectType.class, "onObject", Introspection.DirectiveLocation.OBJECT);
        this.putInMap(functionMap, GraphQLArgument.class, "onArgument", Introspection.DirectiveLocation.ARGUMENT_DEFINITION);
        this.putInMap(functionMap, GraphQLInterfaceType.class, "onInterface", Introspection.DirectiveLocation.INTERFACE);
        this.putInMap(functionMap, GraphQLUnionType.class, "onUnion", Introspection.DirectiveLocation.UNION);
        this.putInMap(functionMap, GraphQLEnumType.class, "onEnum", Introspection.DirectiveLocation.ENUM);
        this.putInMap(functionMap, GraphQLEnumValueDefinition.class, "onEnumValue", Introspection.DirectiveLocation.ENUM_VALUE);
        this.putInMap(functionMap, GraphQLScalarType.class, "onScalar", Introspection.DirectiveLocation.SCALAR);
        this.putInMap(functionMap, GraphQLInputObjectType.class, "onInputObjectType", Introspection.DirectiveLocation.INPUT_OBJECT);
        this.putInMap(functionMap, GraphQLInputObjectField.class, "onInputObjectField", Introspection.DirectiveLocation.INPUT_FIELD_DEFINITION);
        return functionMap;
    }

    public GraphQLDirectiveContainer wire(GraphQLDirectiveContainer element, HashMap<GraphQLDirective, AnnotationsDirectiveWiring> directiveWiringMap) {
        for (Map.Entry<GraphQLDirective, AnnotationsDirectiveWiring> entry : directiveWiringMap.entrySet()) {
            GraphQLDirective graphQLDirective = entry.getKey();
            AnnotationsDirectiveWiring wiring = entry.getValue();
            Class<?> aClass = element.getClass();
            try {
                element = this.functionMap.get(aClass).apply(graphQLDirective, element, wiring);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new GraphQLAnnotationsException(e.getMessage(), e);
            }
        }
        return element;
    }

    private void assertLocation(GraphQLDirective graphQLDirective, GraphQLDirectiveContainer element, Introspection.DirectiveLocation ... validLocations) {
        boolean isSupported = false;
        for (Introspection.DirectiveLocation validLocation : validLocations) {
            if (!graphQLDirective.validLocations().contains(validLocation)) continue;
            isSupported = true;
        }
        if (!isSupported) {
            throw this.getInvalidDirectiveLocationException(element, graphQLDirective, validLocations);
        }
    }

    private InvalidDirectiveLocationException getInvalidDirectiveLocationException(GraphQLDirectiveContainer element, GraphQLDirective graphQLDirective, Introspection.DirectiveLocation ... validLocations) {
        return new InvalidDirectiveLocationException("The element: '" + element.getName() + "' is annotated with the directive: '" + graphQLDirective.getName() + "' which is not valid on the element location: '" + Arrays.toString(Arrays.stream(validLocations).map(Enum::name).toArray()) + "'", null);
    }

    @FunctionalInterface
    static interface WiringFunction {
        public GraphQLDirectiveContainer apply(GraphQLDirective var1, GraphQLDirectiveContainer var2, AnnotationsDirectiveWiring var3) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException;
    }
}

